﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>
#include <nnt.h>

namespace nnt { namespace irsensor {

class ApiResponseMeasure
{
public:
    ApiResponseMeasure() NN_NOEXCEPT
        : m_SamplingCount(0)
        , m_SumResponseTime()
    {};

    ~ApiResponseMeasure() NN_NOEXCEPT
    {
        m_SumResponseTime = nn::TimeSpan::FromNanoSeconds(0);
        m_SamplingCount = 0;
    };

private:
    int m_SamplingCount;
    nn::TimeSpanType m_SumResponseTime;

public:
    // 平均時間を計算します。
    nn::TimeSpanType GetAverageResponseTime() NN_NOEXCEPT
    {
        if (m_SamplingCount != 0)
        {
            return nn::TimeSpan::FromNanoSeconds(m_SumResponseTime.GetNanoSeconds() / m_SamplingCount);
        }
        return nn::TimeSpan::FromNanoSeconds(0);
    };

    // 時間のサンプリングを行います。
    template <typename inner_loop>
    void MeasureFunction(inner_loop func) NN_NOEXCEPT
    {
        nn::os::Tick startTick = nn::os::GetSystemTick();
        // 処理
        func();
        m_SumResponseTime += (nn::os::GetSystemTick() - startTick).ToTimeSpan();
        m_SamplingCount++;
    };
};

}} // namespace nnt::irsensor
