﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
//  nninitStartup 動作確認テスト
//-----------------------------------------------------------------------------

#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/nn_SdkText.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/init.h>

#include <nnt/nntest.h>


namespace nnt { namespace init { namespace startup {

//-----------------------------------------------------------------------------

bool g_CalledStartup = false;
bool g_CalledStartupBeforeStaticInitializer = false;

namespace {

NN_ALIGNAS(4096) char g_mallocBuffer[1024 * 1024];

}

extern "C" void nninitStartup()
{
    g_CalledStartup = true;

    // malloc 用の領域を確保
    nn::init::InitializeAllocator( reinterpret_cast<void*>(g_mallocBuffer), sizeof(g_mallocBuffer) );
}

//-----------------------------------------------------------------------------
// アプリが定義した nninitStartup() が呼ばれたかどうかをチェック
//
// 同時に、静的オブジェクトのコンストラクタよりも前に
// アプリが定義した nninitStartup() が呼ばれたかどうかもチェックする。
//
TEST(NnInitStartup, CheckCalledUserNnInitStartup)
{
    NN_LOG(NN_TEXT("アプリが定義した nninitStartup() が呼ばれたか ... "));

    if (g_CalledStartup)
    {
        NN_LOG("OK\n");
        SUCCEED();
    }
    else
    {
        NN_LOG("NG\n");
        ADD_FAILURE();
    }


    NN_LOG(NN_TEXT("静的オブジェクトのコンストラクタより前に nninitStartup() が呼ばれたか ... "));

    if (g_CalledStartupBeforeStaticInitializer)
    {
        NN_LOG("OK\n");
        SUCCEED();
    }
    else
    {
        NN_LOG("NG\n");
        ADD_FAILURE();
    }
}

//-----------------------------------------------------------------------------
//  静的オブジェクト用のクラス定義
//
class StaticObject
{
public:
    // コンストラクタ
    StaticObject()
    {
        if (g_CalledStartup)
        {
            g_CalledStartupBeforeStaticInitializer = true;
        }
    }
};

StaticObject    g_StaticInstance;

//-----------------------------------------------------------------------------

}}} // namespace nnt::init::startup
