﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
//  nninitSetMallocRegion 動作確認テスト
//-----------------------------------------------------------------------------

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_SdkText.h>
#include <nn/TargetConfigs/build_Compiler.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    // 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
    #pragma warning( disable : 4566 )
#endif

#include <cstdlib>
#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/init.h>

#include <nnt/nntest.h>


namespace nnt { namespace init { namespace startup {

#if defined(NN_BUILD_CONFIG_COMPILER_GCC) || \
    defined(NN_BUILD_CONFIG_COMPILER_CLANG)

//-----------------------------------------------------------------------------
// malloc の呼出し、確保した領域のチェック、free の呼出し
//
TEST(nninitSetMallocRegionTest, testMalloc)
{
    const size_t mallocSize = 5000;

    NN_LOG(NN_TEXT("独自 malloc の呼出し\n"));
    void* address = malloc( mallocSize );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );

    NN_LOG(NN_TEXT("独自 free の呼出し\n"));
    free( address );
    EXPECT_TRUE( true );
}

//-----------------------------------------------------------------------------
// calloc の呼出し、確保した領域のチェック、free の呼出し
//
TEST(nninitSetMallocRegionTest, testCalloc)
{
    const size_t callocSize = 5000;

    NN_LOG(NN_TEXT("独自 calloc の呼出し\n"));
    void* address = calloc( callocSize / 4, 4 );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );

    NN_LOG(NN_TEXT("独自 free の呼出し\n"));
    free( address );
    EXPECT_TRUE( true );
}

//-----------------------------------------------------------------------------
// realloc の呼出し、確保した領域のチェック、free の呼出し
//
TEST(nninitSetMallocRegionTest, testRealloc)
{
    const size_t reallocSize = 5000;

    NN_LOG(NN_TEXT("独自 malloc の呼出し\n"));
    void* address = malloc( reallocSize );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );

    NN_LOG(NN_TEXT("独自 realloc の呼出し（サイズを小さくする）\n"));
    address = realloc( address, reallocSize / 2 );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );

    NN_LOG(NN_TEXT("独自 realloc の呼出し（サイズを大きくする）\n"));
    address = realloc( address, reallocSize * 2 );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );

    NN_LOG(NN_TEXT("独自 realloc の呼出し（size = 0）\n"));
    address = realloc( address, 0 );
    EXPECT_TRUE( address == reinterpret_cast<void*>(1) );
}


//-----------------------------------------------------------------------------
// new の呼出し
//
TEST(nninitSetMallocRegionTest, testNew)
{
    NN_LOG(NN_TEXT("new の呼出し\n"));
    uint32_t* p = new uint32_t[1024 * 1024 / sizeof(uint32_t)];

    NN_LOG(NN_TEXT("new による獲得アドレスが正しいか p=0x%p\n"), p);
    EXPECT_TRUE( p == reinterpret_cast<uint32_t*>(1) );

    delete[] p;
}

//-----------------------------------------------------------------------------
#endif  // GCC or CLANG

}}} // namespace nnt::init::startup

