﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include "testVi_Service.sfdl.h"

namespace nnt{ namespace vi{

    const char ServiceName[] = "vi:T";

    class TestServiceProxy
    {
    public:
        static const size_t ObjectCountMax = 10;
    public:
        TestServiceProxy() NN_NOEXCEPT;
        ~TestServiceProxy() NN_NOEXCEPT;

        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::sf::SharedPointer<Service> GetService() NN_NOEXCEPT;
    private:
        nn::Result InitializeServiceImpl() NN_NOEXCEPT;
        void FinalizeServiceImpl() NN_NOEXCEPT;

    private:
        nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax> m_ClientManager;
        nn::sf::ShimLibraryObjectHolder<Service>                m_ServiceHolder;
    };

}}
