﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>
#include <vector>

#include <nn/omm/omm_Api.h>
#include <nn/usb/pd/usb_Pd.h>
#include <nn/psm/psm_System.h>
#include <nn/vi.private.h>

namespace nnt { namespace usb { namespace pd {

    // クレードルファミリーかどうか
    bool IsCradleFamily( nn::usb::pd::StatusDeviceType deviceType ) NN_NOEXCEPT;

    // クレードル LED 制御が可能かどうか
    bool IsCradleLedControlable( nn::usb::pd::StatusDeviceType deviceType ) NN_NOEXCEPT;

    typedef enum {
        State_Invalid,
        State_NoConnection,
        State_OfficialAcAdaptor,
        State_AnkerMobileBattery,
        State_AnkerPowerPort,
        State_AppleCharger,
        State_GoogleDualPowerPort,
        State_GooglePixelCharger,
        State_RavpowerMobileBattery,
        State_RavpowerMobileBatteryAfterWakeByBatterySaving,
        State_CradleWithNoAcAdaptor,
        State_CradleWithOfficialAcAdaptor,
        State_CradleWithHdmiTvOn,
        State_CradleWithPc,
        State_CradleWithAppleCharger,
        State_CradleOverVoltage,
        State_CradleOverVoltageAfterContract,
        State_RelayBoxWithNoAcAdaptor,
        State_RelayBoxWithHdmiTvOn,
        State_RelayBoxWithPc,
        State_RelayBoxWithAppleCharger,
        State_TableDockWithNoAcAdaptor,
        State_TableDockWithHdmiTvOn,
        State_TableDockWithPc,
        State_TableDockWithAppleCharger,
        State_TableDockWithGooglePixelCharger,
        State_TableDockOverVoltage,
        State_TableDockOverVoltageAfterContract,
        State_Pc,
        State_Nx,
        State_UsbEther,
        State_UsbEtherAfterSleepWithRavpowerMobileBattery,
        State_OverVoltage,
        State_OverVoltageAfterContract,
    } State;

    // 各 State において、API で取れる値が何であるべきかを記述する構造体
    // pair.first がアサートの有効無効を示し、pair.second が期待値を示す
    typedef struct{
        // nn::usb::pd::GetStatus() の結果に対するアサート
        std::pair<bool, bool> isActive;
        std::pair<bool, nn::usb::pd::StatusPlugOrientation> plugOrientation;
        std::pair<bool, nn::usb::pd::StatusDataRole> dataRole;
        std::pair<bool, nn::usb::pd::StatusPowerRole> powerRole;
        std::pair<bool, nn::Bit32> currentPdo;
        std::pair<bool, nn::Bit32> currentRdo;
        std::pair<bool, bool> isElectronicallyMarkedCable;
        std::pair<bool, nn::usb::pd::StatusAccessoryMode> accessoryMode;
        std::pair<bool, bool> isDisplayPortAlternateMode;
        std::pair<bool, bool> isCradlePowerShortage;
        std::pair<bool, bool> isCradleWithUnofficialAcAdaptor;
        std::pair<bool, bool> isTableDockPowerShortage;
        std::pair<bool, bool> isTableDockWithUnofficialAcAdaptor;
        std::pair<bool, nn::usb::pd::StatusDeviceType> deviceType;
        std::pair<bool, nn::usb::pd::StatusRequest> request;
        std::pair<bool, nn::usb::pd::StatusError> error;

        // nn::usb::pd::GetNotice() の結果に対するアサート
        std::pair<bool, int32_t> activeNoticeCountMin;
        std::pair<bool, int32_t> activeNoticeCountMax;

        // nn::psm::GetChargerType() の結果に対するアサート
        std::pair<bool, nn::psm::ChargerType> chargerType;

        // nn::usb::Host::QueryAllInterfaces() の結果に対するアサート
        std::pair<bool, int32_t> ifCount;

        // nn::vi::GetDisplayHotplugState() の結果に対するアサート
        std::pair<bool, nn::vi::HotplugState> hotplugState;

        // nn::omm::GetOperationMode() の結果に対するアサート
        std::pair<bool, nn::omm::OperationMode> operationMode;
    } StateAssert;

    typedef std::map<State, StateAssert> StateAssertMap;

    // TestState のシングルトンを取得。非スレッドセーフ。
    StateAssertMap* GetStateAssertMap() NN_NOEXCEPT;

    // pdStatus が testState に応じた適切な値になっているかテストし、パスしたら true を返す
    bool TestState(State state, const nn::usb::pd::Status &status, int32_t activeNoticeCount, nn::psm::ChargerType chargerType, int32_t ifCount, nn::vi::HotplugState& hotplugState, nn::omm::OperationMode operationMode) NN_NOEXCEPT;
}}}
