﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/psc.h>
#include <nn/psc/psc_PmControl.h>

namespace nnt { namespace psc { namespace util {

nn::Result TimedWaitPmDispatchResult(bool* pOutWasTimedOut, nn::TimeSpan timeout, nn::psc::PmControl* pControl);
nn::Result TimedExecutePmRequest(bool* pOutWasTimedOut, nn::TimeSpan timeout, nn::psc::PmState pmState, nn::psc::PmTransitionOrder order, nn::psc::PmFlagSet flags = nn::psc::MakeNoPmFlags()) NN_NOEXCEPT;

}}}
