﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * FontShaderDataHelper.h
 * -------------------------------------------------
 * This is a generated file from GLSLC shader
 * compile reflection information. Do not edit.
 * -------------------------------------------------
 */

/*
 * Shader Program: FontShader
 *
 * Perf Statistics - Stage: Vertex
 * -------------------------------------------------------------
 * Latency:                           42
 * Number of lmem spill bytes:        0
 * Number of lmem refill bytes:       0
 * Number of smem spill bytes:        0
 * Number of smem refill bytes:       0
 * Lmem Spill Size:                   0
 * Local Memory Non-spill Loads:      0
 * Local Memory Non-spill Stores:     0
 * Non-spill Local Memory Size:       0
 * Occupancy:                         1
 * Number of Divergent Branches:      0
 * Attribute Memory Usage:            24
 * Program Size:                      192
 * Issue Ltd Throughput:              0.333333
 * FP Ltd Throughput:                 1.33333
 * Half Ltd Throughput:               0
 * Trancedental Ltd Throughput:       0
 * IPA Ltd Throughput:                0
 * Shared Ltd Throughput:             0.2
 * ControlFlow Ltd Throughput:        1
 * Texture/Load/Store Ltd Throughput: 0
 * Reg Ltd Throughput:                1.52381
 * Warp Ltd Throughput:               1.52381
 *
 * Perf Statistics - Stage: Fragment
 * -------------------------------------------------------------
 * Latency:                           365
 * Number of lmem spill bytes:        0
 * Number of lmem refill bytes:       0
 * Number of smem spill bytes:        0
 * Number of smem refill bytes:       0
 * Lmem Spill Size:                   0
 * Local Memory Non-spill Loads:      0
 * Local Memory Non-spill Stores:     0
 * Non-spill Local Memory Size:       0
 * Occupancy:                         1
 * Number of Divergent Branches:      0
 * Attribute Memory Usage:            12
 * Program Size:                      256
 * Issue Ltd Throughput:              0.25
 * FP Ltd Throughput:                 0.333333
 * Half Ltd Throughput:               0
 * Trancedental Ltd Throughput:       1
 * IPA Ltd Throughput:                0.333333
 * Shared Ltd Throughput:             0
 * ControlFlow Ltd Throughput:        1
 * Texture/Load/Store Ltd Throughput: 0.25
 * Reg Ltd Throughput:                0.350685
 * Warp Ltd Throughput:               0.350685
 *
 */

#pragma once
#include <cstdint>
#include <string>

namespace FontShader
{

    // Holds a list of attribute data and provides binding information for each attribute
class Attributes
{
    public:
            // Holds information describing a given attribute
            // Data fields are filled with data from the GLSLC compile output
        struct AttributeData
        {
            AttributeData(const std::string& name = "",
                          int32_t location = -1,
                          uint8_t stagesReferencedIn = 0) : m_Name(name),
                                                            m_Location(location),
                                                            m_StagesReferencedIn(stagesReferencedIn)
            {
            }

            std::string m_Name;              // Name of the attribute in the shader
            int32_t m_Location;              // Binding location
            uint8_t m_StagesReferencedIn;    // Bit flag of stages that the attribute is referenced in, of type NVNshaderStageBits
        };

            // Get the binding location for the attribute with the given name
        static int32_t GetAttributeLocation(const std::string& name)
        {
            for(uint32_t i = 0; i < m_NumAttributes; ++i)
            {
                if(m_Attributes[i].m_Name == name)
                    return m_Attributes[i].m_Location;
            }

            return -1;
        }

            // Get the number of vertex attributes in the shader program
        static uint32_t GetNumAttributes()
        {
            return m_NumAttributes;
        }

            // Get the stages the attribute is referenced in
        static uint8_t GetStagesReferencedIn(const std::string& name)
        {
            for(uint32_t i = 0; i < m_NumAttributes; ++i)
            {
                if(m_Attributes[i].m_Name == name)
                    return m_Attributes[i].m_StagesReferencedIn;
            }

            return 0;
        }

        static const AttributeData* GetAttributeList()
        {
            return m_Attributes;
        }

    private:
        static const uint32_t m_NumAttributes = 2;     // Total number of attributes
        static const AttributeData m_Attributes[2];    // Static array of attribute data
};

    // Helper class for the BlockColorFS uniform block
class BlockColorFSUniformBlockData
{
    public:
            // Sets the data at the appropriate offset for the uniform block member: u_color
        void SetUniform_u_color(const float (&uniformData)[4])
        {
            memcpy(&m_BlockData[0], &uniformData, sizeof(uniformData));
        }

            // Get the binding location for the uniform block
            // shaderStage is of type NVNshaderStage
        static uint32_t GetBinding(uint32_t shaderStage)
        {
            return m_Bindings[shaderStage];
        }

            // Get the stages the uniform block is referenced in
        static uint8_t GetStagesReferencedIn()
        {
            return m_StagesReferencedIn;
        }

    private:
        char m_BlockData[16];    // Block of data representing the uniform block

            // Binding location of the uniform block
        static const int32_t m_Bindings[6];
        static const uint8_t m_StagesReferencedIn = 2;    // Bit flag of stages that the attribute is referenced in, of type NVNshaderStageBits
};

    // Helper class for the BlockSamplerFS uniform block
class BlockSamplerFSUniformBlockData
{
    public:
            // Sets the data at the appropriate offset for the uniform block member: u_bindlessTex
        void SetUniform_u_bindlessTex(const uint64_t& uniformData)
        {
            memcpy(&m_BlockData[0], &uniformData, sizeof(uniformData));
        }

            // Get the binding location for the uniform block
            // shaderStage is of type NVNshaderStage
        static uint32_t GetBinding(uint32_t shaderStage)
        {
            return m_Bindings[shaderStage];
        }

            // Get the stages the uniform block is referenced in
        static uint8_t GetStagesReferencedIn()
        {
            return m_StagesReferencedIn;
        }

    private:
        char m_BlockData[16];    // Block of data representing the uniform block

            // Binding location of the uniform block
        static const int32_t m_Bindings[6];
        static const uint8_t m_StagesReferencedIn = 2;    // Bit flag of stages that the attribute is referenced in, of type NVNshaderStageBits
};

    // Helper class for the BlockVS uniform block
class BlockVSUniformBlockData
{
    public:
            // Sets the data at the appropriate offset for the uniform block member: u_scale
        void SetUniform_u_scale(const float (&uniformData)[2])
        {
            memcpy(&m_BlockData[0], &uniformData, sizeof(uniformData));
        }

            // Get the binding location for the uniform block
            // shaderStage is of type NVNshaderStage
        static uint32_t GetBinding(uint32_t shaderStage)
        {
            return m_Bindings[shaderStage];
        }

            // Get the stages the uniform block is referenced in
        static uint8_t GetStagesReferencedIn()
        {
            return m_StagesReferencedIn;
        }

    private:
        char m_BlockData[16];    // Block of data representing the uniform block

            // Binding location of the uniform block
        static const int32_t m_Bindings[6];
        static const uint8_t m_StagesReferencedIn = 1;    // Bit flag of stages that the attribute is referenced in, of type NVNshaderStageBits
};

}

