﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{Model.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a model structure used for reading/writing
 *  model data.
 */

#pragma once

#include <cstdint>
#include <string>
#include <vector>

struct VertexAttribute
{
    std::string m_Name;
    uint32_t    m_DataSize;
    uint32_t    m_ElementSize;
    uint32_t    m_Stride;
    uint32_t    m_NvnFormat;
    uint32_t    m_Location;
    void*       m_pData;
};

struct IndexData
{
    uint32_t m_IndexType;
    uint32_t m_DataSize;
    uint32_t m_Stride;
    void*    m_pData;
};

struct Model
{
    std::string m_Name;
    uint32_t    m_NumVertexAttributes;
    uint32_t    m_NumPrimitives;
    uint32_t    m_NvnDrawPrimitiveType;

    IndexData                    m_IndexData;
    std::vector<VertexAttribute> m_VertexAttributes;
};
