﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include <nn/nn_Result.h>
#include <nn/http.h>
#include <nn/socket.h>
#include <nn/npns.h>

#define SEND_AUTO // 自動で REST API を叩いて通知発行するフラグ

namespace nnt {
namespace npns {
namespace util {

class TestBase : public ::testing::Test
{
protected:
    static void SetUpTestCase();
    static void SetUpTestCaseWithoutConnection();
    static void TearDownTestCase();

    TestBase();

    void PublishNotification(const nn::npns::NotificationToken token, const char* pPayload = "{ value: \\\"test\\\" }");
    void PublishNotificationByTopic(const char* pTopicName, const char* pPayload = "{ value: \\\"test\\\" }");
    void CreateTopic(char* pNameOut, size_t length, nn::ApplicationId appId, const char* pPrefix = "data");
    static bool PollState(nn::npns::State state, const nn::TimeSpan& timeout);

    NotificationPublisher* GetNotificationPublisher();

    virtual void SetUp() NN_OVERRIDE;
    virtual void TearDown() NN_OVERRIDE;

private:
    static void SetUpTestCaseImpl(bool establishConnection);

public:
    static const char* GetStateName(nn::npns::State state);
    static const char* GetDateTimeStr();
};

}
}
}
