﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNpt_Config.h"

//
// NX では testing::Test を使用します。
//

#include <nnt/nntest.h>
#include <nn/nn_Assert.h>

#define NNT_NPT_RESULT_EQUAL(expect, result)                         \
        (                                                               \
            ((expect).GetModule() == (result).GetModule()) &&           \
            ((expect).GetDescription() == (result).GetDescription())    \
        )

#define NNT_NPT_ASSERT(exp)                                NN_ASSERT(exp)
#define NNT_NPT_ASSERT_FATAL(exp)                          NN_ASSERT(exp)
#define NNT_NPT_ASSERT_EQUAL(expect, value)                NN_ASSERT_EQUAL((expect), (value))
#define NNT_NPT_ASSERT_EQUAL_FATAL(expect, value)          NN_ASSERT_EQUAL((expect), (value))
#define NNT_NPT_ASSERT_EQUAL_N(expect, value)              NN_ASSERT((expect) == (value),"TODO") //TODOメッセージを表示
#define NNT_NPT_ASSERT_RESULT_EQUAL(expect, result)        NN_ASSERT(NNT_NPT_RESULT_EQUAL((expect),(result)))
#define NNT_NPT_ASSERT_RESULT_EQUAL_FATAL(expect, result)  NNT_NPT_ASSERT_RESULT_EQUAL((expect),(result))
#define NNT_NPT_ASSERT_RESULT_NOT_EQUAL(lhs, rhs)          NN_ASSERT(!(lhs).Includes(rhs))
#define NNT_NPT_ASSERT_RESULT_SUCCESS_FATAL(exp)           NNT_ASSERT_RESULT_SUCCESS(exp)
#define NNT_NPT_ASSERT_DEATH(exp)                          ASSERT_DEATH(exp,"")

#define NNT_NPT_EXPECT_RESULT_EQUAL(expect, result)                                        \
do                                                                                            \
{                                                                                             \
    nn::Result nn_test_assert_expect = (expect);                                              \
    nn::Result nn_test_assert_result = (result);                                              \
    EXPECT_EQ(nn_test_assert_expect.GetModule(),nn_test_assert_result.GetModule());           \
    EXPECT_EQ(nn_test_assert_expect.GetDescription(),nn_test_assert_result.GetDescription()); \
} while (NN_STATIC_CONDITION(0))

#define NNT_NPT_EXPECT_RESULT_SUCCESS(exp)                                       \
do                                                                                  \
{                                                                                   \
    nn::Result nn_test_assert_result = (exp);                                       \
    EXPECT_TRUE(nn_test_assert_result.IsSuccess());                                 \
} while (NN_STATIC_CONDITION(0))

#define NNT_NPT_DEFINE_MAIN(testsuite)                     NN_TESTEX_DEFINE_MAIN(testsuite)
#define NNT_NPT_SUITE_NAME(name)                           NN_TESTEX_SUITE_NAME(name)
#define NNT_NPT_ADD(func)                                  NN_TESTEX_ADD(func)

#define NNT_NPT_AGING_ASSERT(exp)                                                    \
    do                                                                                  \
    {                                                                                   \
        if(!(exp))                                                                      \
        {                                                                               \
            NN_LOG("# ASSERT @ %s() line:%d %s \n", __FUNCTION__, __LINE__, #exp);      \
        }                                                                               \
    } while (NN_STATIC_CONDITION(0))

#define NNT_NPT_AGING_ASSERT_EQUAL(expect, value) NNT_NPT_AGING_ASSERT((expect) == (value))

#define NNT_NPT_AGING_ASSERT_EQUAL_N(expect, value)                                  \
    do                                                                                  \
    {                                                                                   \
        if ((expect) != (value))                                                        \
        {                                                                               \
            NN_LOG("expect: %s (=%d)\n", #expect, (expect));                            \
            NN_LOG("value: %s (=%d)\n", #value, (value));                               \
            NN_LOG("# ASSERT @ %s() line:%d %s == %s \n",                               \
                   __FUNCTION__, __LINE__, #expect, #value);                            \
        }                                                                               \
    } while (NN_STATIC_CONDITION(0))

#define NNT_NPT_AGING_ASSERT_NOT_EQUAL_N(expect, value)                              \
do                                                                                      \
{                                                                                       \
    if ((expect) == (value))                                                            \
    {                                                                                   \
        NN_LOG("expect: %s (=%d)\n", #expect, (expect));                                \
        NN_LOG("value: %s (=%d)\n", #value, (value));                                   \
        NN_LOG("# ASSERT @ %s() line:%d %s != %s \n",                                   \
               __FUNCTION__, __LINE__, #expect, #value);                                \
    }                                                                                   \
} while (NN_STATIC_CONDITION(0))

#define NNT_NPT_AGING_ASSERT_RESULT_EQUAL(expect, result)                                   \
    do                                                                                         \
    {                                                                                          \
        nn::Result nn_test_assert_expect = (expect);                                           \
        nn::Result nn_test_assert_result = (result);                                           \
        if((nn_test_assert_expect.GetModule() != nn_test_assert_result.GetModule()) ||         \
           (nn_test_assert_expect.GetDescription() != nn_test_assert_result.GetDescription())) \
        {                                                                                      \
            NN_LOG("expect:\n");                                                               \
            NN_LOG("  Module=%d Description=%d \n",nn_test_assert_expect.GetModule(),   \
                   nn_test_assert_expect.GetDescription());                             \
            NN_LOG("result:\n");                                                        \
            NN_LOG("  Module=%d Description=%d \n",nn_test_assert_result.GetModule(),   \
                   nn_test_assert_result.GetDescription());                             \
            NN_LOG("# ASSERT @ %s() line:%d %s \n", __FUNCTION__, __LINE__, #expect);   \
        }                                                                               \
    } while (NN_STATIC_CONDITION(0))

#define NNT_NPT_AGING_ASSERT_RESULT_SUCCESS(exp)                                     \
    do                                                                                  \
    {                                                                                   \
        nn::Result nn_test_assert_result = (exp);                                       \
        if(nn_test_assert_result.IsFailure())                                           \
        {                                                                               \
            NN_LOG("result:\n");                                                        \
            NN_LOG("  Module=%d Description=%d \n",nn_test_assert_result.GetModule(),   \
                   nn_test_assert_result.GetDescription());                             \
            NN_LOG("# ASSERT @ %s() line:%d %s \n", __FUNCTION__, __LINE__, #exp);      \
        }                                                                               \
    } while (NN_STATIC_CONDITION(0))

namespace nnt { namespace npt {

    class TestFramework : public ::testing::Test
    {
    protected:
        nn::nfc::DeviceHandle m_DeviceHandle;

        TestFramework() NN_NOEXCEPT {}

        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE {}

        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE {}
    };

}}
