﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNfp_Config.h"

namespace nnt { namespace nfp {
    //------------------------------------------------------------------
    // ユーティリティ関数用定数です
    //------------------------------------------------------------------

    //======================================================
    // テストで使用するデータです。
    //======================================================

    extern const uint32_t ZeroTagId;
    extern const uint32_t NormalTagId;
    extern const uint32_t NfpManagerUsedTagId;
    extern const nn::Bit8 ZeroTagData[nn::nfp::ApplicationAreaSizeV2];
    extern const nn::Bit8 NormalTagData[nn::nfp::ApplicationAreaSizeV2];
    extern const nn::Bit8 NormalTagData1[nn::nfp::ApplicationAreaSizeV2];
    extern const nn::Bit8 NormalTagData2[nn::nfp::ApplicationAreaSizeV2];
    extern const nn::Bit8 NormalTagData3[nn::nfp::ApplicationAreaSizeV2];
    extern const nn::Bit8 NormalTagMiiData[nnt::nfp::TestMiiDataSize];
    extern const unsigned char NormalTagNickName[nn::nfp::NicknameLengthMax * 4 + 1];
    extern const unsigned char NormalTagNickName2[nn::nfp::NicknameLengthMax * 4 + 1];
    extern const unsigned char NormalTagNickName3[nn::nfp::NicknameLengthMax * 4 + 1];
    extern const unsigned char NormalTagNickName4[nn::nfp::NicknameLengthMax * 4 + 1];

    extern const nn::Bit8 MiiData1[nnt::nfp::TestMiiDataSize];
    extern const nn::Bit8 MiiData2[nnt::nfp::TestMiiDataSize];

    extern const nn::hid::NpadIdType NpadIds[];
    extern const int NpadIdCountMax;

    enum MiiDataPattern
    {
        MiiDataPattern_0 = 0,
        MiiDataPattern_1,
        MiiDataPattern_2,
        MiiDataPattern_3,
    };

    //==================================================
    // プラットフォーム毎に異なる処理をラップします。
    //==================================================

    nn::Result InitializeSystem() NN_NOEXCEPT;
    nn::Result FinalizeSystem() NN_NOEXCEPT;

    nn::Result SetDefaultActivateEvent() NN_NOEXCEPT;
    nn::Result SetDefaultDeactivateEvent() NN_NOEXCEPT;
    nn::Result SetDefaultAvailabilityChangeEvent() NN_NOEXCEPT;
    void DestroyDefaultActivateEvent() NN_NOEXCEPT;
    void DestroyDefaultDeactivateEvent() NN_NOEXCEPT;
    void DestroyDefaultAvailabilityChangeEvent() NN_NOEXCEPT;
    bool WaitForActivate(int ms) NN_NOEXCEPT;
    bool WaitForActivate() NN_NOEXCEPT;
    bool WaitForDeactivate(int ms) NN_NOEXCEPT;
    bool WaitForDeactivate() NN_NOEXCEPT;
    bool WaitForAvailabilityChange(int ms) NN_NOEXCEPT;
    bool WaitForAvailabilityChange() NN_NOEXCEPT;
    bool WaitForConnect(int ms) NN_NOEXCEPT;
    bool WaitForConnect() NN_NOEXCEPT;
    bool WaitForDisconnect(int ms) NN_NOEXCEPT;
    bool WaitForDisconnect() NN_NOEXCEPT;

    //==================================================
    // NFP ライブラリの API をラップしてリトライに対応した関数です。
    //==================================================

    nn::Result InitializeWithRetry() NN_NOEXCEPT;
    nn::Result InitializeSystemWithRetry() NN_NOEXCEPT;
    nn::Result MountWithRetry() NN_NOEXCEPT;
    nn::Result MountRomWithRetry() NN_NOEXCEPT;
    nn::Result FlushWithRetry() NN_NOEXCEPT;
    nn::Result FlushDebugWithRetry() NN_NOEXCEPT;
    nn::Result RestoreWithRetry() NN_NOEXCEPT;
    nn::Result FormatWithRetry(const nn::Bit8* pDefaultData, int32_t defaultDataSize) NN_NOEXCEPT;
    nn::Result FormatWithRetry() NN_NOEXCEPT;
    nn::Result CreateApplicationAreaWithRetry(const nn::nfp::ApplicationAreaCreateInfo& info) NN_NOEXCEPT;
    nn::Result DeleteApplicationAreaWithRetry() NN_NOEXCEPT;
    nn::Result DeleteNfpRegisterInfoWithRetry() NN_NOEXCEPT;
    nn::Result BreakTagWithRetry(nn::nfp::BreakType breakType) NN_NOEXCEPT;

    //==================================================
    // 頻繁に利用されるシーケンスをまとめた関数です。
    //==================================================

    nn::nfp::DeviceHandle GetCurrentDeviceHandle() NN_NOEXCEPT;
    void SetCurrentDeviceHandle(nn::nfp::DeviceHandle deviceHandle) NN_NOEXCEPT;
    nn::Result SearchDeviceHandle() NN_NOEXCEPT;
    void DoSearchDeviceHandle() NN_NOEXCEPT;
    void DoConnect() NN_NOEXCEPT;
    void DoConnectForFwUpdate() NN_NOEXCEPT;
    void DoSearch() NN_NOEXCEPT;
    void DoActivate() NN_NOEXCEPT;
    void DoMount() NN_NOEXCEPT;
    void DoMountRom() NN_NOEXCEPT;
    void DoOpenApplicationArea(nn::Bit32 accessId) NN_NOEXCEPT;
    void DoFormat(const nn::Bit8* pDefaultData, int32_t defaultDataSize) NN_NOEXCEPT;
    void DoCreateNormalTag() NN_NOEXCEPT;
    void DoCreateZeroTag() NN_NOEXCEPT;

    void DoMountAndEnd() NN_NOEXCEPT;
    void DoMountRomAndEnd() NN_NOEXCEPT;
    void DoFormatAndEnd(const nn::Bit8* pDefaultData, int32_t defaultDataSize) NN_NOEXCEPT;
    void DoCreateNormalTagAndEnd() NN_NOEXCEPT;
    void DoCreateZeroTagAndEnd() NN_NOEXCEPT;
    bool DoExistsApplicationArea() NN_NOEXCEPT;

    //==================================================
    // その他のユーティリティです。
    //==================================================

    void Sleep(int ms) NN_NOEXCEPT;
    void* AlignBuffer(void* pBuffer, int alignment) NN_NOEXCEPT;
    nn::nfp::Date GetCurrentDate();
    void SetNextDate();
    void SetPreviousDate();

#if !defined(NNT_NFP_PLATFORM_NX) //NX には国コードがない
    nn::cfg::CfgCountryCode GetCountry();
#endif //!defined(NNT_NFP_PLATFORM_NX)

    void WifiOn() NN_NOEXCEPT;
    void WifiOff() NN_NOEXCEPT;

    bool IsAllZero( const void* pBuffer, int size ) NN_NOEXCEPT;
    void CreateRandomNumberSequence(nn::Bit8* pOut, int size) NN_NOEXCEPT;
    void CreateRandomNumberSequence(nn::Bit16* pOut, int size) NN_NOEXCEPT;
    void CreateRandomAllowAsciiCodeSequence(nn::Bit8* pOut, int size) NN_NOEXCEPT;
    void* MallocAndGetAlignedPtr(void* pOutAllocMem, uint32_t mallocSize, uint32_t alignment) NN_NOEXCEPT;
    void UpdateTime() NN_NOEXCEPT;
    void FlushNfp() NN_NOEXCEPT;
    void MountNfp() NN_NOEXCEPT;
    void MountRomNfp() NN_NOEXCEPT;
    void RegisterNfp() NN_NOEXCEPT;
    void RegisterNfpType1() NN_NOEXCEPT;
    void RegisterNfpType2() NN_NOEXCEPT;
    nn::nfp::TagInfo GetTagInfoNfp() NN_NOEXCEPT;
    void StartNfp(uint32_t accessId, const nn::Bit8* pAppData, uint32_t appSize) NN_NOEXCEPT;
    void EndNfp() NN_NOEXCEPT;
    void FormatNfp() NN_NOEXCEPT;

#if defined(NNT_NFP_PLATFORM_CAFE)
    nn::Result CheckBackupNfp();
#elif defined(NNT_NFP_PLATFORM_CTR)
    bool CheckBackupNfp();
#endif // defined(NNT_NFP_PLATFORM_CTR)

#if !defined(NNT_NFP_PLATFORM_NX) //NX には国コードがない
    void SetCountry(nn::cfg::CTR::CfgCountryCode country);
    uint16_t GetSystemWriteCounter();
    nn::mii::BirthPlatform GetBirthPlatform();
#endif //!defined(NNT_NFP_PLATFORM_NX)

    void CreateDummyBackupData(int count, void* pBackupBuffer, size_t bufferSize) NN_NOEXCEPT;

#if !defined(NNT_NFP_PLATFORM_NX) //NX には国コードがない
    void UpdateCountry();
#endif //!defined(NNT_NFP_PLATFORM_NX)
    void InitSpecificTest() NN_NOEXCEPT;

    const char* GetNfpResultTypeString(nn::Result result) NN_NOEXCEPT;
    bool CheckNpadStyle(nn::hid::NpadIdType npadId) NN_NOEXCEPT;
    bool IsNfcEnable() NN_NOEXCEPT;

    nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo) NN_NOEXCEPT;

    void InitializeHidController() NN_NOEXCEPT;
    void BuildMiiData(nn::mii::StoreData& miiData) NN_NOEXCEPT;
    void BuildAnotherMiiData(nn::mii::StoreData& miiData) NN_NOEXCEPT;
    void BuildMiiData(nn::mii::StoreData& miiData, MiiDataPattern pattern) NN_NOEXCEPT;

    nn::Result InitializeNfcSystem() NN_NOEXCEPT;
    nn::Result FinalizeNfcSystem() NN_NOEXCEPT;

#if defined(NNT_NFP_PLATFORM_NX)
    void DeleteSystemSaveData() NN_NOEXCEPT;
#endif // defined(NNT_NFP_PLATFORM_NX)
}} // end of namespace nnt::nfp

