﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

//
// デバッグ用のログ出力の有効・無効を切り替えるスイッチです。
//
// NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG
// デバッグレベルのログ出力を有効化します。
//
// NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO
// 情報レベルのログ出力を有効化します。
//
// NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING
// 警告レベルのログ出力を有効化します。
//
// NNT_LDN_BUILD_CONFIG_DEBUG_LOG_DISABLED
// ログ出力を無効化します。
//
#define NNT_LDN_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO 1 // NOLINT(preprocessor/const)

//
// フライトモード関連テストの有効／無効を切り替えるスイッチです。
//
// NNT_LDN_BUILD_CONFIG_FLIGHT_MODE_ENABLED
// フライトモード関連のテストを有効化します。
//
// NNT_LDN_BUILD_CONFIG_FLIGHT_MODE_DISABLED
// フライトモード関連のテストを無効化します。
//
#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NNT_LDN_BUILD_CONFIG_FLIGHT_MODE_DISABLED 1  // NOLINT(preprocessor/const)
#else
#define NNT_LDN_BUILD_CONFIG_FLIGHT_MODE_ENABLED 1  // NOLINT(preprocessor/const)
#endif

//
// 試遊台関連テストの有効／無効を切り替えるスイッチです。
//
// NNT_LDN_BUILD_CONFIG_LOCK_ENABLED
// フライトモード関連のテストを有効化します。
//
// NNT_LDN_BUILD_CONFIG_LOCK_DISABLED
// フライトモード関連のテストを無効化します。
//
#if defined(NN_BUILD_CONFIG_OS_WIN)
#define NNT_LDN_BUILD_CONFIG_LOCK_DISABLED 1  // NOLINT(preprocessor/const)
#else
#define NNT_LDN_BUILD_CONFIG_LOCK_ENABLED 1  // NOLINT(preprocessor/const)
#endif

//
// XML の解析に使用するライブラリを切り替えるスイッチです。
//
// NNT_LDN_BUILD_CONFIG_USE_PUGIXML
// pugixml を使用します。
//
#define NNT_LDN_BUILD_CONFIG_USE_PUGIXML 1 // NOLINT(preprocessor/const)
