﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>

/**
 * @brief       シグナルの発生を期待するアサートです。
 * @param[in]   e           対象のイベントです。
 * @param[in]   t           タイムアウト時間です。
 */
#define NNT_LDN_ASSERT_SIGNALED(e, t)\
    ASSERT_TRUE((e).TimedWait((t)))

/**
 * @brief       シグナルの発生を期待するアサートです。多少の余裕をもってタイムアウトします。
 * @param[in]   e           対象のイベントです。
 * @param[in]   t           タイムアウト時間です。
 */
#define NNT_LDN_ASSERT_SIGNALED_WEAK(e, t)\
    NNT_LDN_ASSERT_SIGNALED((e), ((t) + ::nn::TimeSpan::FromSeconds(1)))

/**
 * @brief       シグナルが発生しないことを期待するアサートです。
 * @param[in]   e           対象のイベントです。
 * @param[in]   t           タイムアウト時間です。
 */
#define NNT_LDN_ASSERT_NOT_SIGNALED(e, t)\
    ASSERT_FALSE((e).TimedWait((t))
