﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nnt { namespace ldn { namespace detail
{
    /**
     * @brief       テストブリッジから受信するエラーコードです。
     */
    enum SynchronizationErrorCode
    {
        SynchronizationErrorCode_Success,
        SynchronizationErrorCode_Unknown,
        SynchronizationErrorCode_InvalidState,
        SynchronizationErrorCode_InvalidFormat,
        SynchronizationErrorCode_Duplicate,
        SynchronizationErrorCode_NotFound,
        SynchronizationErrorCode_Full,
        SynchronizationErrorCode_Timeout
    };

    void BuildCreateGroupRequest(
        void* buffer, size_t* pOutSize, size_t bufferSize,
        const char* groupName, int clientCount) NN_NOEXCEPT;

    void BuildJoinGroupRequest(
        void* buffer, size_t* pOutSize, size_t bufferSize, const char* groupName) NN_NOEXCEPT;

    void BuildLeaveRequest(void* buffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT;

    void BuildSyncRequest(
        void* buffer, size_t* pOutSize, size_t bufferSize, const char* keyword,
        const void* data, size_t dataSize,  nn::TimeSpan timeout) NN_NOEXCEPT;

    bool ParseCreateGroupResponse(
        SynchronizationErrorCode* pOutError, char* xml) NN_NOEXCEPT;

    bool ParseJoinGroupResponse(
        SynchronizationErrorCode* pOutError, char* xml,
        int* pOutClientCount, int* pOutClientIndex) NN_NOEXCEPT;

    bool ParseSyncResponse(
        SynchronizationErrorCode* pOutError, char* xml,
        void* buffer, size_t* dataSize, size_t bufferSize) NN_NOEXCEPT;

}}} // namespace nnt::ldn::detail
