﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/lcs.h>

namespace nnt { namespace lcs
{
    /**
     * @brief       タイムアウト付でセッションを探索します。
     * @param[out]  pOutSession             見つかったセッションの出力先です。
     * @param[out]  pOutCount               見つかったセッションの数です。
     * @param[out]  pOutIndex               ホスト名が一致するセッションのインデックスです。
     * @param[in]   bufferCount             pOutSession に格納できる SessionInfo の数です。
     * @param[in]   hostName                対象のセッションのホスト名です。
     * @param[in]   timeout                 タイムアウト時間です。
     * @return      処理の成否です。
     */
    nn::Result TimedScan(
        nn::lcs::SessionInfo* pOutSession, int* pOutCount, int* pOutIndex, int bufferCount,
        const char* hostName, nn::TimeSpan timeout) NN_NOEXCEPT;

    /**
     * @brief       タイムアウト付でセッションに接続します。
     * @param[in]   session                 接続先のセッションです。
     * @param[in]   timeout                 タイムアウト時間です。
     * @return      処理の成否です。
     */
    nn::Result TimedJoin(
        const nn::lcs::SessionInfo& session, nn::TimeSpan timeout) NN_NOEXCEPT;

    /**
     * @brief       タイムアウト付でセッションに際接続します。
     * @param[in]   context                 接続先のセッションのコンテキストです。
     * @param[in]   timeout                 タイムアウト時間です。
     * @return      処理の成否です。
     */
    nn::Result TimedResumeSession(
        const nn::lcs::SessionContext& context, nn::TimeSpan timeout) NN_NOEXCEPT;

    /**
     * @brief       タイムアウト付で Transferring 状態からの状態遷移を待機します。
     * @param[in]   state                   遷移後の状態です。
     * @param[in]   pEvent                  状態遷移時にシグナルされるイベントです。
     * @param[in]   timeout                 タイムアウト時間です。
     */
    void TimedWaitTransition(
        nn::lcs::State state, nn::os::SystemEventType* pEvent, nn::TimeSpan timeout) NN_NOEXCEPT;

}} // namespace nnt::lcs
