﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs.h>

namespace nnt { namespace lcs
{

    /**
     * @brief       LCS ライブラリの初期化を RAII で実施するヘルパです。
     */
    class Initializer
    {
    public:

        /**
         * @brief       LCS ライブラリを初期化します。
         */
        Initializer(void* buffer, size_t bufferSize, const nn::lcs::Config& config) NN_NOEXCEPT;

        /**
         * @brief       LCS ライブラリを解放します。
         */
        ~Initializer() NN_NOEXCEPT;
    };

    /**
     * @brief       NS ライブラリの初期化を RAII で実施するヘルパです。
     */
    class NsInitializer
    {
    public:

        /**
         * @brief       NS ライブラリを初期化します。
         */
        NsInitializer() NN_NOEXCEPT;

        /**
         * @brief       NS ライブラリを解放します。
         */
        ~NsInitializer() NN_NOEXCEPT;
    };


    /**
     * @brief       ホストとしてのセッション構築を RAII で実施するヘルパです。
     */
    class HostStarter
    {
    public:

        /**
         * @brief       セッションを構築します。
         */
        explicit HostStarter(const nn::lcs::SessionSettings& settings) NN_NOEXCEPT;

        /**
         * @brief       セッションを破棄します。
         */
        ~HostStarter() NN_NOEXCEPT;
    };

    /**
     * @brief       プロトコルバージョンの設定を RAII で実施するヘルパです。
     */
    class ProtocolVersionSetter
    {
    public:

        /**
         * @brief       プロトコルバージョンを設定します。
         * @param[in]   major           メジャーバージョンです。
         * @param[in]   minor           マイナーバージョンです。
         */
        ProtocolVersionSetter(int major, int minor) NN_NOEXCEPT;

        /**
         * @brief       プロトコルバージョンを元に戻します。
         */
        ~ProtocolVersionSetter() NN_NOEXCEPT;

    private:

        int m_Major;
        int m_Minor;
    };

}} // namespace nnt::lcs
