﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/mem/mem_StandardAllocator.h>
#include "testGraphics_AllocatorFunction.h"

namespace nnt{ namespace graphics{

    class InitializeAllocatorFunctionForStandardAllocator
    {
    public:
        static void Initialize(AllocatorFunction* pOutAllocatorFunction, nn::mem::StandardAllocator* pStandardAllocator)
        {
            NN_ABORT_UNLESS_NOT_NULL(pOutAllocatorFunction);
            NN_ABORT_UNLESS_NOT_NULL(pStandardAllocator);
            pOutAllocatorFunction->allocateFunction = AllocateFunction;
            pOutAllocatorFunction->freeFunction = FreeFunction;
            pOutAllocatorFunction->pArgument = pStandardAllocator;
        }
    private:
        static void* AllocateFunction(size_t size, size_t alignment, void* obj)
        {
            NN_ABORT_UNLESS_NOT_NULL(obj);
            nn::mem::StandardAllocator* pSa = reinterpret_cast<nn::mem::StandardAllocator*>(obj);
            return pSa->Allocate(size, alignment);
        }
        static void FreeFunction(void* ptr, void* obj)
        {
            NN_ABORT_UNLESS_NOT_NULL(obj);
            nn::mem::StandardAllocator* pSa = reinterpret_cast<nn::mem::StandardAllocator*>(obj);
            pSa->Free(ptr);
        }
    };

}}

