﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_Result.h>
#include "testGraphics_Path.h"

namespace nnt{ namespace graphics{

    //! @brief 指定したパスとその祖先のディレクトリをすべて作成します。
    //! @param[in] path 作成するディレクトリのパス
    //! @return すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。それ以外の場合、エラーの値を返します。
    //! @details 指定したパスとその祖先のディレクトリをすべて作成します。
    nn::Result CreateDirectories(const char* path);
    //! @brief 指定したパスとその祖先のディレクトリをすべて作成します。
    //! @param[in] path 作成するディレクトリのパス
    //! @return すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。それ以外の場合、エラーの値を返します。
    //! @details 指定したパスとその祖先のディレクトリをすべて作成します。
    nn::Result CreateDirectories(const Path* path);
    //! @brief 指定したパスとその祖先のディレクトリをすべて作成します。
    //! @param[in] path 作成するディレクトリのパス
    //! @return すべてのディレクトリの作成に成功するか、既にディレクトリが存在している場合成功を返します。それ以外の場合、エラーの値を返します。
    //! @details 指定したパスとその祖先のディレクトリをすべて作成します。
    nn::Result CreateDirectories(const Path& path);

}}
