﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <vector>

#include <nn/util/util_FormatString.h>

#include <nnt/fsUtil/testFs_util_allocator.h>

namespace nnt { namespace fs { namespace util {

typedef std::basic_string<char, std::char_traits<char>, StdAllocator<char>> String;

// std::to_string の代替

inline String ToString(double value) NN_NOEXCEPT
{
    char buffer[512];
    nn::util::SNPrintf(buffer, sizeof(buffer), "%lf", value);
    return String(buffer);
}

inline String ToString(int64_t value) NN_NOEXCEPT
{
    char buffer[512];
    nn::util::SNPrintf(buffer, sizeof(buffer), "%lld", value);
    return String(buffer);
}

inline String ToString(int value) NN_NOEXCEPT
{
    char buffer[512];
    nn::util::SNPrintf(buffer, sizeof(buffer), "%d", value);
    return String(buffer);
}

template<typename T>
using Vector = std::vector<T, StdAllocator<T>>;

template<typename T, typename ... Arguments>
inline std::shared_ptr<T> AllocateShared(Arguments ... arguments) NN_NOEXCEPT
{
    StdAllocator<T> allocator;
    return std::allocate_shared<T, StdAllocator<T>>(allocator, arguments ...);
}

}}}
