﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/fsUtil/testFs_util_fixture.h>

namespace nnt { namespace fs { namespace util {

void LoadMountTest() NN_NOEXCEPT;

typedef void (*MountTestHook)();

struct MountTestAttribute
{
    bool isNotAbortedByTooLongPath;
    bool isReservedMountNameSupported;
    bool isGlobalNewCallExpected;
    bool isTestSkipRequired;
    MountTestHook setUp;
    MountTestHook tearDowm;
};

typedef nn::Result (*MountByNameFunction)(const char* name);
typedef nn::Result (*MountByPathFunction)(const char* name, const char* path);
typedef const MountTestAttribute (*GetMountTestAttributeFunction)();

struct MountTestParameter
{
    const char* mountName;
    MountByNameFunction mountByName;
    MountByPathFunction mountByPath;
    GetMountTestAttributeFunction getMountTestAttribute;
};

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
void PrintTo(const MountTestParameter& parameter, ::std::ostream* os) NN_NOEXCEPT;
#else
void PrintTo(const MountTestParameter& parameter, ::nnt::testing::detail::StringStream* os) NN_NOEXCEPT;
#endif

class WithMountFunction : public ::testing::WithParamInterface<MountTestParameter>
{
protected:
    nn::Result MountByName(const char* name) NN_NOEXCEPT;
    nn::Result MountAndUnmountByNameSafely(const char* name) NN_NOEXCEPT;

    nn::Result MountByPath(const char* path) NN_NOEXCEPT;
    nn::Result MountAndUnmountByPathSafely(const char* path) NN_NOEXCEPT;

    const MountTestAttribute GetAttribute() NN_NOEXCEPT;

    void SetUp() NN_NOEXCEPT;
    void TearDown() NN_NOEXCEPT;
};

class MountBasic : public CheckGlobalNewDeleteFlagTestFixture, public WithMountFunction, public PrepareWorkDirFixture
{
protected:
    void SetUpWithParam() NN_NOEXCEPT
    {
        if( GetAttribute().isGlobalNewCallExpected )
        {
            DisableCheck();
        }

        WithMountFunction::SetUp();
    }

    void TearDownWithParam() NN_NOEXCEPT
    {
        WithMountFunction::TearDown();

        if( GetAttribute().isGlobalNewCallExpected )
        {
            EXPECT_TRUE(nnt::fs::util::IsGlobalNewDeleteCalled());
        }
    }
};

typedef MountBasic MountFailure;

class MountPathDeathTest : public ::testing::Test, public WithMountFunction
{
protected:
    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
    {
        ::testing::Test::SetUp();
        WithMountFunction::SetUp();
    }

    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
    {
        ::testing::Test::TearDown();
        WithMountFunction::TearDown();
    }
};

}}}

#define NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(prefix, generator) \
    INSTANTIATE_TEST_CASE_P( \
        prefix, \
        MountBasic, \
        generator \
    ); \
    INSTANTIATE_TEST_CASE_P( \
        prefix, \
        MountFailure, \
        generator \
    ); \
    INSTANTIATE_TEST_CASE_P( \
        prefix, \
        MountPathDeathTest, \
        generator \
    )
