﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nnt/fsUtil/testFs_util_allocator.h>

// nnMain のあるソースに include して使用します
// このため、関数は inline をつけません

void* operator new(size_t size)
{
    nnt::fs::util::SetGlobalNewDeleteFlag();
    return std::malloc(size);
}

void* operator new(size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    nnt::fs::util::SetGlobalNewDeleteFlag();
    return std::malloc(size);
}

void operator delete(void* pointer) NN_NOEXCEPT
{
    std::free(pointer);
}

void operator delete(void* pointer, const std::nothrow_t&) NN_NOEXCEPT
{
    std::free(pointer);
}

void* operator new[](size_t size)
{
    nnt::fs::util::SetGlobalNewDeleteFlag();
    return std::malloc(size);
}

void* operator new[](size_t size, const std::nothrow_t&) NN_NOEXCEPT
{
    nnt::fs::util::SetGlobalNewDeleteFlag();
    return std::malloc(size);
}

void operator delete[](void* pointer) NN_NOEXCEPT
{
    std::free(pointer);
}

void operator delete[](void* pointer, const std::nothrow_t&) NN_NOEXCEPT
{
    std::free(pointer);
}
