﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Log.h>
#include <nn/diag/diag_AbortObserver.h>
#include <nn/util/util_ScopeExit.h>

namespace nnt { namespace fs { namespace util {

class AbortDisabler
{
public:
    AbortDisabler() NN_NOEXCEPT
    {
        nn::diag::InitializeAbortObserverHolder(&m_AbortObserverHolder,
            [](const nn::diag::AbortInfo&) NN_NOEXCEPT
            {
                NN_LOG("Test aborted as expected.\n");
                for( ; ; )
                {
                }
            });
        nn::diag::RegisterAbortObserver(&m_AbortObserverHolder);
    }

    ~AbortDisabler() NN_NOEXCEPT
    {
        nn::diag::UnregisterAbortObserver(&m_AbortObserverHolder);
    }

private:
    nn::diag::AbortObserverHolder m_AbortObserverHolder;
};

}}}
