﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/detail/fs_Newable.h>
#include <nn/fs/fsa/fs_IFileSystem.h>

#include <nnt/nntest.h>

namespace nnt { namespace fs { namespace util { namespace mock {

namespace fsa {

class MockFileSystem : public nn::fs::fsa::IFileSystem, public nn::fs::detail::Newable
{
public:
    MOCK_METHOD3(DoCreateFile, nn::Result(const char* path, int64_t size, int option));
    MOCK_METHOD1(DoDeleteFile, nn::Result(const char* path));
    MOCK_METHOD1(DoCreateDirectory, nn::Result(const char* path));
    MOCK_METHOD1(DoDeleteDirectory, nn::Result(const char* path));
    MOCK_METHOD1(DoDeleteDirectoryRecursively, nn::Result(const char* path));
    MOCK_METHOD1(DoCleanDirectoryRecursively, nn::Result(const char* path));
    MOCK_METHOD2(DoRenameFile, nn::Result(const char* currentPath, const char* newPath));
    MOCK_METHOD2(DoRenameDirectory, nn::Result(const char* currentPath, const char* newPath));
    MOCK_METHOD2(DoGetEntryType, nn::Result(nn::fs::DirectoryEntryType* outValue, const char* path));
    MOCK_METHOD2(DoGetFreeSpaceSize, nn::Result(int64_t* outValue, const char* path));
    MOCK_METHOD2(DoGetTotalSpaceSize, nn::Result(int64_t* outValue, const char* path));
    MOCK_METHOD3(DoOpenFile, nn::Result(std::unique_ptr<nn::fs::fsa::IFile>* outValue, const char* path, nn::fs::OpenMode mode));
    MOCK_METHOD3(DoOpenDirectory, nn::Result(std::unique_ptr<nn::fs::fsa::IDirectory>* outValue, const char* path, nn::fs::OpenDirectoryMode mode));
    MOCK_METHOD0(DoCommit, nn::Result());
};

}

}}}}
