﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/fsApi/testFs_Unit_Api.h>
#include <nnt/fsApiSaveDataExtraData/testFs_ApiSaveDataExtraData.h>

namespace nnt { namespace fs { namespace api {

class FsApiUnitTestSaveDataExtraDataAccessor : public ITestSaveDataExtraDataAccessor
{
public:
    explicit FsApiUnitTestSaveDataExtraDataAccessor(nn::fssystem::ISaveDataExtraDataAccessor* pAccessor) NN_NOEXCEPT
        : m_pAccessor(pAccessor)
    {
    }
    virtual ~FsApiUnitTestSaveDataExtraDataAccessor() NN_NOEXCEPT
    {
        m_pAccessor = nullptr;
    }
    virtual Result WriteExtraData(const nn::fs::SaveDataExtraData& extraData) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_pAccessor->WriteExtraData(extraData));
        NN_RESULT_SUCCESS;
    }
    virtual Result CommitExtraData(bool isUpdateTimeStampRequired) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_pAccessor->CommitExtraData(isUpdateTimeStampRequired));
        NN_RESULT_SUCCESS;
    }
    virtual Result ReadExtraData(nn::fs::SaveDataExtraData* outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_pAccessor->ReadExtraData(outValue));
        NN_RESULT_SUCCESS;
    }

private:
    nn::fssystem::ISaveDataExtraDataAccessor* m_pAccessor;
};

class FsApiUnitTestSaveDataFileSystem : public FsApiUnitTestFileSystem
{
public:
    FsApiUnitTestSaveDataFileSystem() NN_NOEXCEPT
        : FsApiUnitTestFileSystem(),
          m_SaveDataExtraDataAccessor(nullptr)
    {
    }
    FsApiUnitTestSaveDataFileSystem(
        std::unique_ptr<nn::fs::fsa::IFileSystem>&& pFileSystem,
        nn::fssystem::ISaveDataExtraDataAccessor* pSaveDataExtraDataAccessor
    ) NN_NOEXCEPT
        : FsApiUnitTestFileSystem(std::move(pFileSystem)),
          m_SaveDataExtraDataAccessor(pSaveDataExtraDataAccessor)
    {
    }

    ITestSaveDataExtraDataAccessor* GetSaveDataExtraDataAccessor() NN_NOEXCEPT
    {
        return &m_SaveDataExtraDataAccessor;
    }

private:
    FsApiUnitTestSaveDataExtraDataAccessor m_SaveDataExtraDataAccessor;
};

}}}
