﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace edid {
    struct DisplayModeInfo;
    struct DisplayTimingInfo;
    struct ImageSizeInfo;
}}

namespace nnt { namespace edid {

    class FullModeInfo
    {
        NN_DISALLOW_COPY(FullModeInfo);
    public:
        FullModeInfo() NN_NOEXCEPT;
        FullModeInfo(const nn::edid::DisplayModeInfo* pMode,
                     const nn::edid::DisplayTimingInfo* pTimingInfo,
                     const nn::edid::ImageSizeInfo* pSizeInfo) NN_NOEXCEPT;
        FullModeInfo(FullModeInfo&& copy) NN_NOEXCEPT;

        ~FullModeInfo() NN_NOEXCEPT;

        nn::edid::DisplayModeInfo* pMode;
        nn::edid::DisplayTimingInfo* pTimingInfo;
        nn::edid::ImageSizeInfo* pSizeInfo;
    };

}}
