﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/codec/codec_OpusCommon.h>
#include <nn/codec/codec_OpusEncoderTypes.h>
#include <nn/codec/detail/codec_OpusEncoderTypesInternal.h>

namespace nnt {
namespace codec {
namespace util {

/**
 * @brief       テストで想定している最大フレーム数
 */
const int OpusFrameCountMax = 48;

/**
 * @brief       テストで想定している最大ストリーム数
 */
const int OpusStreamCountMax = 255;

struct OpusPacketConfiguration
{
    int channelCount;                          //!< ストリーム内チャンネル数
    int frameInMicroSeconds;                   //!< フレーム
    nn::codec::OpusCodingMode codingMode;      //!< 符号化モード
    nn::codec::OpusBandwidth bandwidth;        //!< ストリームのバンド幅
    int streamCount;                           //!< ストリーム数
    int frameCount;                            //!< フレーム数
    std::size_t frameSizes[OpusFrameCountMax]; //!< フレーム数 (未使用)
    bool vbr;                                  //!< 可変フレーム長かどうか
    std::size_t paddingSize;                   //!< パディング数
};

/**
 * @brief       OpusPacketConfiguration 構造体を規定値に初期化します。
 */
bool DefaultOpusPacket(
    struct OpusPacketConfiguration* pConfiguration) NN_NOEXCEPT;

/**
 * @brief       opus パケットを生成します。
 */
bool MakeOpusPacket(
    std::size_t* pOutputDataSize,
    uint8_t* outputBuffer,
    std::size_t outputSize,
    const struct OpusPacketConfiguration& configuration) NN_NOEXCEPT;

/**
 * @brief       opus パケット内の各種情報を取得します。
 */
nn::codec::OpusResult GetOpusPacketBandwidth(nn::codec::OpusBandwidth* pBandwidth, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketCodingMode(nn::codec::OpusCodingMode* pCodingMode, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketChannelCount(int* pChannelCount, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketFrameInMicroSeconds(int* pFrameInMicroSeconds, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketFrameCount(int* pFrameCount, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketPaddingSize(int* pPaddingSize, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;
nn::codec::OpusResult GetOpusPacketVbr(bool* pVbr, const uint8_t* pOpusPacket, std::size_t opusPacketSize) NN_NOEXCEPT;

}}} // nnt::codec::util
