﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef>
#include <nn/nn_Macro.h>

namespace nnt {
namespace codec {

class ObjectBase
{
protected:
    ObjectBase() NN_NOEXCEPT
        : m_IsInitialized(false)
    {}

    inline bool IsInitialized() const NN_NOEXCEPT
    {
        return m_IsInitialized;
    }

    bool m_IsInitialized;
};

}} // nnt::codec
