﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef> // nullptr, std::size_t
#include <cstdlib> // std::malloc, std::free

#include <nnt/codecUtil/testCodec_TestBase.h>
#include <nnt/codecUtil/testCodec_NativeOpusDecoder.h>

namespace nnt {
namespace codec {

template <typename DecoderType>
class NativeOpusDecoderBase
{
protected:
    NativeOpusDecoderBase() NN_NOEXCEPT
        : decoder()
        , decoderWorkBufferAddress(nullptr)
        , decoderWorkBufferSize(0)
    {}

    virtual ~NativeOpusDecoderBase() NN_NOEXCEPT
    {
        if (decoder.IsInitialized())
        {
            decoder.Finalize();
        }
        if (nullptr != decoderWorkBufferAddress)
        {
            std::free(decoderWorkBufferAddress);
        }
        decoderWorkBufferAddress = nullptr;
    }

    void Initialize(const TestParameterSet& parameterSet, bool alloc = true) NN_NOEXCEPT
    {
        // Define some aliases
        const int& sampleRate = parameterSet.sampleRate;
        const int& streamCount = parameterSet.streamCount;
        const int& coupledStreamCount = parameterSet.coupledStreamCount;
        NN_ASSERT_NOT_EQUAL(sampleRate, 0);
        NN_ASSERT_LESS_EQUAL(coupledStreamCount, streamCount);
        // Initializing
        decoderWorkBufferSize = decoder.GetWorkBufferSize(sampleRate, streamCount, coupledStreamCount);
        if (alloc)
        {
            decoderWorkBufferAddress = std::malloc(decoderWorkBufferSize);
            ASSERT_NE(nullptr, decoderWorkBufferAddress);
        }
        // decoder.Initialize() を呼ぶかどうかはテスト次第なので、ここではしない。
    }

    void Finalize() NN_NOEXCEPT
    {
        if (decoder.IsInitialized())
        {
            decoder.Finalize();
        }
        if (nullptr != decoderWorkBufferAddress)
        {
            std::free(decoderWorkBufferAddress);
        }
        decoderWorkBufferAddress = nullptr;
        decoderWorkBufferSize = 0;
    }

    NativeOpusDecoder<DecoderType> decoder;
    void* decoderWorkBufferAddress;
    std::size_t decoderWorkBufferSize;
};

}} // nnt::codec
