﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstddef> // nullptr, std::size_t
#include <cstdlib> // std::malloc, std::free

#include <nnt/codecUtil/testCodec_TestBase.h>
#include <nnt/codecUtil/testCodec_ObjectBase.h>

namespace nnt {
namespace codec {

// Derive and use
class EncodedDataBufferBase
    : protected ObjectBase
{

protected:
    EncodedDataBufferBase() NN_NOEXCEPT
        : m_EncodedDataBufferAddress(nullptr)
        , encodedDataBufferSize(0)
        , encodedDataSize(0)
        , usedDataSize(0)
    {}

    virtual ~EncodedDataBufferBase() NN_NOEXCEPT
    {
        if (nullptr != m_EncodedDataBufferAddress)
        {
            std::free(m_EncodedDataBufferAddress);
        }
        m_EncodedDataBufferAddress = nullptr;
        encodedDataBuffer = nullptr;
    }

    void Initialize(const TestParameterSet& parameterSet) NN_NOEXCEPT
    {
        NN_UNUSED(parameterSet);
        encodedDataBufferSize = nn::codec::OpusPacketSizeMaximum;
        m_EncodedDataBufferAddress = std::malloc(encodedDataBufferSize);
        ASSERT_NE(nullptr, m_EncodedDataBufferAddress);
        encodedDataBuffer = static_cast<uint8_t*>(m_EncodedDataBufferAddress);
        // Done
        m_IsInitialized = true;
    }

    void Finalize() NN_NOEXCEPT
    {
        m_IsInitialized = false;
        if (nullptr != m_EncodedDataBufferAddress)
        {
            std::free(m_EncodedDataBufferAddress);
        }
        m_EncodedDataBufferAddress = nullptr;
        encodedDataBuffer = nullptr;
        encodedDataBufferSize = 0;
        encodedDataSize = 0;
        usedDataSize = 0;
    }

private:
    void* m_EncodedDataBufferAddress;

protected:
    uint8_t* encodedDataBuffer;
    std::size_t encodedDataBufferSize;
    std::size_t encodedDataSize;
    std::size_t usedDataSize;
};

}} // nnt::codec
