﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/atk.h>
#include <nnt/atkUtil/testAtk_Util.h>

namespace nnt { namespace atk { namespace util {

    class SoundThreadStatistics
    {
    public:
        explicit SoundThreadStatistics(int offset) NN_NOEXCEPT;
        SoundThreadStatistics() NN_NOEXCEPT;

        void AddProfile(nn::atk::SoundThreadUpdateProfile& profile) NN_NOEXCEPT;

        void PrintMeanProfile(const char* label) NN_NOEXCEPT;
        void PrintMaxProfile(const char* label) NN_NOEXCEPT;

        void Reset() NN_NOEXCEPT;

    private:
        nnt::atk::util::Statistics<int64_t> m_SoundThreadProcess;
        nnt::atk::util::Statistics<int64_t> m_UpdateLowLevelVoiceProcess;
        nnt::atk::util::Statistics<int64_t> m_FrameProcess;
        nnt::atk::util::Statistics<int64_t> m_UserEffectProcess;
        nnt::atk::util::Statistics<int64_t> m_UpdateRendererProcess;
        nnt::atk::util::Statistics<int64_t> m_WaitRendererEventProcess;
        int m_OffsetCount;
    };

}}}
