﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief   テストライブラリのヘッダをまとめてインクルードするためのヘッダです。
 *  @details 全体で共用できる定義を Tests/Common に置く時には、
 *           このファイルに追記することで、個別のヘッダをインクルードする手間を省くことが出来ます。
 *
 *           このファイルへの追加は、各自の判断で自由に行って構いません。
 *           追加するときは、上記の条件に合うことを確認してください。
 */

#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>
