﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file 実行環境での、入出力ディレクトリのパスを管理します。
 */

namespace nnt { namespace image { namespace jpeg { namespace io {

/**
    @brief 入力元のディレクトリパスを取得します。
    @param[out] path 取得されたパスが格納されます。
    @param[in] pathSize pathのバイト数を指定します。
    @return パスとして有効な文字列をpathに格納したときにtrueが返ります。
    @detail ここで取得されたパスをマウントすることで抽象化します。
 */
bool GetAssetDirectoryPath(char *path, size_t pathSize);

/**
    @brief 出力先ディレクトリパスを取得します。
    @param[out] path 取得されたパスが格納されます。
    @param[in] pathSize pathのバイト数を指定します。
    @return パスとして有効な文字列をpathに格納したときにtrueが返ります。
    @detail ここで取得されたパスをマウントすることで抽象化します。
 */
bool GetOutputDirectoryPath(char *path, size_t pathSize);

}}}}
