﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

#include <nn/oe/oe_IdlePolicyApi.h>
#include <nn/oe/oe_IdlePolicyApiForApplicationSpecificControl.h>

TEST(testOe_IdlePolicyApiTest, Extend)
{
    NN_UTIL_SCOPE_EXIT
    {
        nn::oe::SetUserInactivityDetectionTimeExtended(false);
    };

    // 基本形
    nn::oe::SetUserInactivityDetectionTimeExtended(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Enabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtended(false);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Disabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());

    // ExtendUnsafe との複合
    nn::oe::SetUserInactivityDetectionTimeExtended(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Enabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_EnabledUnsafe, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtended(false);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Disabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
}

TEST(testOe_IdlePolicyApiTest, ExtendUnsafe)
{
    NN_UTIL_SCOPE_EXIT
    {
        nn::oe::SetUserInactivityDetectionTimeExtended(false);
    };

    // 基本形
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_EnabledUnsafe, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(false);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Disabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());

    // Extend との複合
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_EnabledUnsafe, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtended(true);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Enabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(false);
    EXPECT_EQ(nn::oe::UserInactivityDetectionTimeExtensionMode_Disabled, nn::oe::GetUserInactivityDetectionTimeExtensionMode());
}

TEST(testOe_IdlePolicyApiTest, IsExtended)
{
    NN_UTIL_SCOPE_EXIT
    {
        nn::oe::SetUserInactivityDetectionTimeExtended(false);
    };

    // 基本形
    nn::oe::SetUserInactivityDetectionTimeExtended(false);
    EXPECT_FALSE(nn::oe::IsUserInactivityDetectionTimeExtended());
    nn::oe::SetUserInactivityDetectionTimeExtended(true);
    EXPECT_TRUE(nn::oe::IsUserInactivityDetectionTimeExtended());
    nn::oe::SetUserInactivityDetectionTimeExtendedUnsafe(true);
    EXPECT_TRUE(nn::oe::IsUserInactivityDetectionTimeExtended());
}

TEST(testOe_ReportUserIsActive, Call)
{
    // 呼べることだけのテスト
    nn::oe::ReportUserIsActive();
}
