﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/hid/system/hid_InputDetection.h>
#include "HidStub.h"

namespace {
    nn::hid::system::InputSourceState g_InputSourceState;
}

namespace nn { namespace hid { namespace system {

    void InitializeInputDetector() NN_NOEXCEPT
    {
        g_InputSourceState.timestamp = 0;
    }

    void GetInputSourceState(InputSourceState* pOutValue, const InputSourceIdSet& id) NN_NOEXCEPT
    {
        NN_UNUSED(id);
        *pOutValue = g_InputSourceState;
    }

}}} // namespace nn::hid::system

namespace nnt { namespace hid { namespace system {

    using namespace ::nn::hid::system;

    void SetInputSourceState(const InputSourceState& value) NN_NOEXCEPT
    {
        g_InputSourceState = value;
    }

}}} // namespace nnt::hid::system


