﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include <nnt/nntest.h>

#include "../Common/test_Util.h"
#include "../TargetDevices/test_Alc5639.h"
#include "../TargetDevices/test_Max77620.h"
#include "../TargetDevices/test_Tmp451.h"
#include "../TargetDevices/test_Bq24193.h"

TEST( TargetSpecificNX, Max77620 )
{
    // PMIC Max77620 parameters
    const int                TargetBusIdx       = 4; // I2C5

    // デバイスはハイスピードモードに対応しているもののテストに失敗する状況です。対処完了し次第テストに追加します。
    const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Fast };

    const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

    EXPECT_TRUE( nnt::i2c::max77620::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
}

TEST( TargetSpecificNX, Tmp451 )
{
    // Temperature sensor TMP451 parameters
    const int                TargetBusIdx       = 0; // GEN1_I2C
    const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Standard };
    const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

    EXPECT_TRUE( nnt::i2c::tmp451::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
}

// I2cDevice 名によるアクセスができるかをテストします
TEST( TargetSpecificNX, I2cDeviceNameAccess )
{
    EXPECT_TRUE( nnt::i2c::tmp451::TEST_I2cDeviceAccess() );
    EXPECT_TRUE( nnt::i2c::alc5639::TEST_I2cDeviceAccess() );
    EXPECT_TRUE( nnt::i2c::max77620::TEST_I2cDeviceAccess() );
    EXPECT_TRUE( nnt::i2c::bq24193::TEST_I2cDeviceAccess() );
}
