﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include <nnt/nntest.h>

#include "../Common/test_Util.h"
#include "../TargetDevices/test_Alc5639.h"
#include "../TargetDevices/test_Max77620.h"
#include "../TargetDevices/test_Tmp451.h"

TEST( TargetSpecificJetsonTK2, Max77620 )
{
// 別プロセスが速度を設定済みだと ASSERT で落ちるため、プロセス抜きのテストができるまでコメントアウト
#if 0
    // PMIC Max77620 parameters
    const int                TargetBusIdx       = 4; // I2C5

    // デバイスはハイスピードモードに対応しているもののテストに失敗する状況です。対処完了し次第テストに追加します。
    const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Standard ,
                                                    nn::i2c::SpeedMode::SpeedMode_Fast     ,
                                                    nn::i2c::SpeedMode::SpeedMode_FastPlus };

    const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

    EXPECT_TRUE( nnt::i2c::max77620::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
#endif
    EXPECT_TRUE( nnt::i2c::max77620::TEST_I2cDeviceAccess() );
}

TEST( TargetSpecificJetsonTK2, Tmp451 )
{
// 別プロセスが速度を設定済みだと ASSERT で落ちるため、プロセス抜きのテストができるまでコメントアウト
#if 0
    // Temperature sensor TMP451 parameters
    // Hid プロセスがこの Bus に対して事前に SpeedMode を設定しているため、同じ SpeedMode のみテストする
    const int                TargetBusIdx       = 0; // GEN1_I2C
    const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Fast };
    const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

    EXPECT_TRUE( nnt::i2c::tmp451::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
#endif
    EXPECT_TRUE( nnt::i2c::tmp451::TEST_I2cDeviceAccess() );
}

TEST( TargetSpecificJetsonTK2, Alc5639 )
{
// 別プロセスが速度を設定済みだと ASSERT で落ちるため、プロセス抜きのテストができるまでコメントアウト
#if 0
    // Audio Codec ALC5639 parameters
    // Hid プロセスがこの Bus に対して事前に SpeedMode を設定しているため、同じ SpeedMode のみテストする
    const int                TargetBusIdx       = 0;
    const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Fast };
    const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

    EXPECT_TRUE( nnt::i2c::alc5639::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
#endif
    EXPECT_TRUE( nnt::i2c::alc5639::TEST_I2cDeviceAccess() );
}
