﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/i2c.h>
#include <nn/i2c/i2c_BusDev.h> // Include development header not in nn/i2c/i2c.h

#include <nnt/nntest.h>

#include "../Common/test_Util.h"
#include "../TargetDevices/test_Alc5639.h"
#include "../TargetDevices/test_Tmp451.h"

namespace
{
const int                TargetBusIdx       = 0;
const nn::i2c::SpeedMode TargetSpeedModes[] = { nn::i2c::SpeedMode::SpeedMode_Standard ,
                                                nn::i2c::SpeedMode::SpeedMode_Fast     ,
                                                nn::i2c::SpeedMode::SpeedMode_FastPlus };
const int                TargetSpeedModeNum = sizeof(TargetSpeedModes) / sizeof(TargetSpeedModes[0]);

}

// At24c02 もテストしたかったら EEPROM 固有のプロトコルの実装が必要（I2C ドライバ側もたぶん要対応）
#if 0
TEST( TargetSpecificJetsonTK1, At24c02 )
{
    // EEPROM At24c02 parameters
    const int                TargetBusIdx       = 0;
    const nn::Bit16          TargetSlaveAddr    = 0x56;
    const nn::i2c::SpeedMode TargetSpeedMode  = nn::i2c::SpeedMode::SpeedMode_Fast;

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    nn::i2c::OpenSessionForDev(&i2c, TargetBusIdx, TargetSlaveAddr, nn::i2c::AddressingMode_BitWidth7, TargetSpeedMode);

    nn::i2c::CloseSession(i2c);
    nn::i2c::Finalize();
}
#endif

// 正しいコマンドと期待値の組み合わせが必要
#if 0
TEST( TargetSpecificJetsonTK1, As3722 )
{
    // PMIC AS3722 parameters
    const int                TargetBusIdx       = 4;
    const nn::Bit16          TargetSlaveAddr    = 0x40;
    const nn::i2c::SpeedMode TargetSpeedMode  = nn::i2c::SpeedMode::SpeedMode_Fast;

    // Codec registers
    const uint8_t  As3722RegDeviceId           = 0x90;
    const uint8_t  As3722DeviceId              = 0x0c;

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    nn::i2c::OpenSessionForDev(&i2c, TargetBusIdx, TargetSlaveAddr, nn::i2c::AddressingMode_BitWidth7, TargetSpeedMode);

    TestReadRegister(i2c,
        reinterpret_cast<const char*>(&As3722RegDeviceId),  sizeof(As3722RegDeviceId),
        reinterpret_cast<const char*>(&As3722DeviceId),     sizeof(As3722DeviceId)
        );
    if (::testing::Test::HasFatalFailure())
    {
        nn::i2c::CloseSession(i2c);
        nn::i2c::Finalize();
        return;
    }

    nn::i2c::CloseSession(i2c);
    nn::i2c::Finalize();
}
#endif

// TODO: 複数デバイスの共存テストに対応する
#if 0
TEST( TargetSpecificJetsonTK1, Tmp451AndAlc5639 )
{
    // ALC5639 needs LDO1_EN input enabled via GPIO
    nn::gpio::Initialize();
    nn::gpio::GpioPadSession gpioSession;

    nnt::i2c::alc5639::SetUpGpioForAlc5639(&gpioSession);

    nn::i2c::Initialize();

    for( int i = 0; i < TargetSpeedModeNum; i++ )
    {
        nn::i2c::I2cSession tmp451I2c;
        nn::i2c::I2cSession alc5639I2c;

        NN_LOG("Test @ SpeedMode = %d [bps]\n", TargetSpeedModes[i]);

        nn::i2c::OpenSessionForDev(&tmp451I2c,  TargetBusIdx, nnt::i2c::tmp451::SlaveAddr,  nn::i2c::AddressingMode_BitWidth7, TargetSpeedModes[i]);
        nn::i2c::OpenSessionForDev(&alc5639I2c, TargetBusIdx, nnt::i2c::alc5639::SlaveAddr, nn::i2c::AddressingMode_BitWidth7, TargetSpeedModes[i]);

        nnt::i2c::util::TestReadRegister(tmp451I2c,
            reinterpret_cast<const char*>(&nnt::i2c::tmp451::RegVendorId),        sizeof(nnt::i2c::tmp451::RegVendorId),
            reinterpret_cast<const char*>(&nnt::i2c::tmp451::DefaultValVendorId), sizeof(nnt::i2c::tmp451::DefaultValVendorId)
            );
        if (::testing::Test::HasFatalFailure())
        {
            nn::i2c::CloseSession(tmp451I2c);
            nn::i2c::CloseSession(alc5639I2c);
            nn::i2c::Finalize();
            return;
        }

        nnt::i2c::util::TestReadRegister(alc5639I2c,
            reinterpret_cast<const char*>(&nnt::i2c::alc5639::RegSpkoutVol), sizeof(nnt::i2c::alc5639::RegSpkoutVol),
            reinterpret_cast<const char*>(&nnt::i2c::alc5639::DefaultValSpkoutVol), sizeof(nnt::i2c::alc5639::DefaultValSpkoutVol)
            );
        if (::testing::Test::HasFatalFailure())
        {
            nn::i2c::CloseSession(tmp451I2c);
            nn::i2c::CloseSession(alc5639I2c);
            nn::i2c::Finalize();
            return;
        }

        nnt::i2c::util::TestReadRegister(alc5639I2c,
            reinterpret_cast<const char*>(&nnt::i2c::alc5639::RegVendorId),         sizeof(nnt::i2c::alc5639::RegVendorId),
            reinterpret_cast<const char*>(&nnt::i2c::alc5639::DefaultValVendorId),  sizeof(nnt::i2c::alc5639::DefaultValVendorId)
            );
        if (::testing::Test::HasFatalFailure())
        {
            nn::i2c::CloseSession(tmp451I2c);
            nn::i2c::CloseSession(alc5639I2c);
            nn::i2c::Finalize();
            return;
        }

        nn::i2c::CloseSession(tmp451I2c);
        nn::i2c::CloseSession(alc5639I2c);
    }

    nn::i2c::Finalize();

    nn::gpio::CloseSession(gpioSession);
    nn::gpio::Finalize();
}
#endif

TEST( TargetSpecificJetsonTK1, Tmp451 )
{
    EXPECT_TRUE( nnt::i2c::tmp451::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
}

TEST( TargetSpecificJetsonTK1, Alc5639 )
{
    EXPECT_TRUE( nnt::i2c::alc5639::TEST_VariousSpeedModes( TargetBusIdx, TargetSpeedModes, TargetSpeedModeNum ) );
}
