﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  クラシックコントローラ関連パラメータ
//---------------------------------------------------------------------------

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace i2c { namespace clsic {

//---------------------------------------------------------------------------
//  テスト用関数
//---------------------------------------------------------------------------

/**
 * @brief       基本的な送受信が機能していることをテストします
 *
 * @param[in]   readTestTimes      コントローラデータ取得テストの回数
 * @return      テストが成功したかどうかを返します
 * @retval      true        指定回数分のコントローラ取得テストに成功
 * @retval      false       指定回数分のコントローラ取得テストに失敗
 * @pre         クラシックコントローラがボードに接続されている必要があります。
 * @details     readTestTimes 回分クラシックコントローラのコントローラ入力を取得します。
 *              コントローラデータ取得処理の前にクラシックコントローラの初期化処理が行われます。
 *              コントローラデータ要求のための Send() 、受信のための Receive() が呼ばれます。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
bool TEST_BasicTransaction( int readTestTimes );

/**
 * @brief       Auto Increment なレジスタアクセスができていることをテストします
 *
 * @param[in]   autoIncrementTestTimes  コントローラデータ取得テストの回数
 * @return      テストが成功したかどうかを返します
 * @retval      true        成功
 * @retval      false       失敗
 * @pre         クラシックコントローラがボードに接続されている必要があります。
 * @details     クラシックコントローラのレジスタアドレス 0x00 - 0xFF までを、
 *              一括で読み出す Auto Increment 方式を行います。
 *              コントローラデータ取得処理の前と、レジスタ読み出し時にクラシックコントローラの初期化処理が行われます。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
bool TEST_AutoIncrementAccess( int autoIncrementTestTimes );

/**
 * @brief       ExecuteCommandList() のテストをします
 *
 * @return      テストが成功したかどうかを返します
 * @retval      true        成功
 * @retval      false       失敗
 * @pre         クラシックコントローラがボードに接続されている必要があります。
 * @details     クラシックコントローラを対向デバイスとして、コマンドリスト実行の動作テストを行います。
 *              デバイス固有の ID を読み出し、それが適切な値であるかを確認します。
 *              コントローラデータ取得処理の前にクラシックコントローラの初期化処理が行われます。
 *              テスト内部で生成したセッションはクローズされ、ライブラリは未初期化状態に戻ります。
 */
bool TEST_CommandList();

}}}  // namespace nnt::i2c::clsic
