﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/i2c/i2c.h>

#include "tool_Bq24193.h"

namespace nnt { namespace i2c { namespace bq24193 {

nn::Result DumpRegisters()
{
    const uint8_t regFieldLength = 0x0b;

    NN_LOG("[bq24193] Start to dump\n");

    nn::i2c::Initialize();

    nn::i2c::I2cSession i2c;
    uint8_t value = 0;

    nn::i2c::OpenSession(&i2c, nn::i2c::I2cDevice_Bq24193);

    for ( uint8_t index = 0; index < regFieldLength; index++ )
    {
        NN_RESULT_DO(nn::i2c::ReadSingleRegister(&value, i2c, &index));

        NN_LOG("[bq24193] %02x : %02x\n", index, value);
    }

    nn::i2c::CloseSession(i2c);

    nn::i2c::Finalize();

    NN_LOG("[bq24193] End\n");

    NN_RESULT_SUCCESS;
}

}}}  // namespace nnt::i2c::bq24193
