﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class TestServer
    {
        public delegate void UtilFunction(TcpClient client);

        private readonly Thread m_Thread;
        private readonly TcpListener m_TcpListener;
        private readonly HtcsPeerName m_HtcsPeerName;
        private readonly string m_HtcsPortName;
        private readonly HtcsCommunicator m_HtcsCommunicator;
        private readonly UtilFunction m_UtilFunction;
        private HtcsPortDescriptor m_HtcsPortDesc;

        public TestServer(int tcpPortNumber, string htcsPeerName, string htcsPortName, HtcsCommunicator htcsCommunicator, UtilFunction utilFunction)
        {
            m_Thread = new Thread(ThreadFunc);
            m_TcpListener = new TcpListener(System.Net.IPAddress.Loopback, tcpPortNumber);
            m_HtcsPeerName = new HtcsPeerName(htcsPeerName);
            m_HtcsPortName = htcsPortName;
            m_HtcsCommunicator = htcsCommunicator;
            m_UtilFunction = utilFunction;
        }

        public TestServer(int tcpPortNumber, string htcsPortName, HtcsCommunicator htcsCommunicator, UtilFunction utilFunction)
        {
            m_Thread = new Thread(ThreadFunc);
            m_TcpListener = new TcpListener(System.Net.IPAddress.Loopback, tcpPortNumber);
            m_HtcsPeerName = HtcsPeerName.Any;
            m_HtcsPortName = htcsPortName;
            m_HtcsCommunicator = htcsCommunicator;
            m_UtilFunction = utilFunction;
        }

        public void Start()
        {
            // サーバの構築
            m_TcpListener.Start();
            m_Thread.Start();

            // TargetManager にサーバ情報を登録
            m_HtcsPortDesc = new HtcsPortDescriptor(m_HtcsPeerName, m_HtcsPortName);
            PortMapItem portMapping = new PortMapItem(m_HtcsPortDesc, ((System.Net.IPEndPoint)m_TcpListener.LocalEndpoint));
            while (m_HtcsCommunicator.RegisterPort(portMapping) != 0)
            {
                Console.WriteLine("Registration error: {0}.", m_HtcsPortName);
                Thread.Sleep(1000);
            }
        }

        public void Wait()
        {
            m_Thread.Join();
            m_TcpListener.Stop();

            // 登録していたポート情報を削除します。
            m_HtcsCommunicator.UnregisterPort(m_HtcsPortDesc);
        }

        private void ThreadFunc()
        {
            TcpClient client = m_TcpListener.AcceptTcpClient();
            m_UtilFunction(client);
            client.Close();
        }
    }
}
