﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class TestClient
    {
        public delegate void UtilFunction(TcpClient client);

        private readonly Thread m_Thread;
        private readonly TcpClient m_TcpClient;
        private readonly string m_HtcsPortName;
        private readonly HtcsCommunicator m_HtcsCommunicator;
        private readonly UtilFunction m_UtilFunction;

        public TestClient(string htcsPortName, HtcsCommunicator htcsCommunicator, UtilFunction utilFunction)
        {
            m_Thread = new Thread(ThreadFunc);
            m_TcpClient = new TcpClient();
            m_HtcsPortName = htcsPortName;
            m_HtcsCommunicator = htcsCommunicator;
            m_UtilFunction = utilFunction;
        }

        public void Start()
        {
            // HTCS ポート名が m_HtcsPortName のもののうち、最初に見つかったものに接続
            // TODO: 複数ターゲット対応
            while (true)
            {
                try
                {
                    PortMapItem portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == m_HtcsPortName);
                    m_TcpClient.Connect(portMapItem.EndPoint);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }
                catch (SocketException se)
                {
                    Console.WriteLine("Socket exception occurred({0})", se.ErrorCode);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }

            m_Thread.Start();
        }

        public void Wait()
        {
            m_Thread.Join();
            m_TcpClient.Close();
        }

        private void ThreadFunc()
        {
            m_UtilFunction(m_TcpClient);
        }
    }
}
