﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace StressTestTool
{
    internal class DisconnectTest
    {
        private readonly string m_KeyString;
        private readonly HtcsCommunicator m_HtcsCommunicator;

        public DisconnectTest(string keyString, HtcsCommunicator htcsCommunicator)
        {
            m_KeyString = keyString;
            m_HtcsCommunicator = htcsCommunicator;
        }

        public void Start()
        {
            Console.WriteLine("\n\n[ClientSendTest] ------------------\n\n");
            CloseSendTest();

            Console.WriteLine("\n\n[ClientRecvTest] ------------------\n\n");
            CloseRecvTest();

            Console.WriteLine("\n\n[ShutdownReadServerTest] ----------\n\n");
            ShutdownReadServerTest();

            Console.WriteLine("\n\n[ShutdownWriteServerTest] ---------\n\n");
            ShutdownWriteServerTest();

            Console.WriteLine("\n\n[ShutdownReadWriteServerTest] ---------\n\n");
            ShutdownReadWriteServerTest();
        }

        public void CloseSendTest()
        {
            const int DataSize = 512 * 1024 * 1024;

            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "TargetToHost_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }
            var client = new TcpClient();
            client.Connect(portMapItem.EndPoint);
            try
            {
                using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
                {
                    byte[] data;
                    data = reader.ReadBytes(DataSize);
                    while (data.Length > 0)
                    {
                        data = reader.ReadBytes(DataSize);
                    }
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
            client.Close();
        }

        public void CloseRecvTest()
        {
            const int DataSize = 512 * 1024 * 1024;

            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "HostToTarget_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }
            var client = new TcpClient();
            client.Connect(portMapItem.EndPoint);
            try
            {
                using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
                {
                    while (true)
                    {
                        byte[] data = new byte[DataSize];
                        writer.Write(data);
                        writer.Flush();
                    }
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
            client.Close();
        }

        public void ShutdownReadServerTest()
        {
            const int DataSize = 32 * 1024 * 1024;

            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "ShutdownRead_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }

            var client = new TcpClient();
            client.Connect(portMapItem.EndPoint);
            using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
            using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
            {
                byte[] data = reader.ReadBytes(DataSize);
                if (data.Length != DataSize)
                {
                    Console.Error.WriteLine("Error : data.Length != Datasize");
                }
                try
                {
                    writer.Write(data);
                    writer.Flush();
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }

            // 対向のエラー確認前に Close しないように一定時間待つ
            Thread.Sleep(1000);
            client.Close();
        }

        public void ShutdownWriteServerTest()
        {
            const int DataSize = 32 * 1024 * 1024;

            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "ShutdownWrite_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }
            var client = new TcpClient();
            client.Connect(portMapItem.EndPoint);
            using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
            using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
            {
                // 送信データの用意
                byte[] data = new byte[DataSize];

                writer.Write(data);
                writer.Flush();

                try
                {
                    reader.ReadBytes(DataSize);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }

            // 対向のエラー確認前に Close しないように一定時間待つ
            Thread.Sleep(1000);
            client.Close();
        }

        public void ShutdownReadWriteServerTest()
        {
            const int DataSize = 32 * 1024 * 1024;

            PortMapItem portMapItem;
            while (true)
            {
                try
                {
                    portMapItem = m_HtcsCommunicator.PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == "ShutdownReadWrite_" + m_KeyString);
                    break;
                }
                catch (InvalidOperationException ioe)
                {
                    Console.WriteLine("Invalid operation occurred({0:X8})", ioe.HResult);
                }

                // 例外発生時、しばらく待ってやり直す
                Thread.Sleep(1000);
            }
            var client = new TcpClient();
            client.Connect(portMapItem.EndPoint);
            using (var reader = new BinaryReader(client.GetStream(), Encoding.ASCII, true))
            using (var writer = new BinaryWriter(client.GetStream(), Encoding.ASCII, true))
            {
                // 送信データの用意
                byte[] data = new byte[DataSize];

                try
                {
                    writer.Write(data);
                    writer.Flush();
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }

                try
                {
                    reader.ReadBytes(DataSize);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }

            // 対向のエラー確認前に Close しないように一定時間待つ
            Thread.Sleep(1000);
            client.Close();
        }
    }
}
