﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Result.h>

// Result に対する ASSERT_TRUE 的なもの
#define NNT_HTCLOW_ASSERT_RESULT_SUCCESS(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { nnt::htclow::PrintResult(_r, __FILE__, __LINE__); ASSERT_TRUE(_r.IsSuccess());} } while (NN_STATIC_CONDITION(false))

#define NNT_HTCLOW_ASSERT_RESULT_INCLUDED(exp, result) \
    do { nn::Result _r = (result); if (!(_r <= exp)) { nnt::htclow::PrintResult(_r, __FILE__, __LINE__); ASSERT_TRUE(_r <= exp);} } while (NN_STATIC_CONDITION(false))


namespace nnt { namespace htclow {

/*
 * @brief   htclow ライブラリが対応しているバージョンの最大値を返します。
 */
int16_t GetMaxVersion() NN_NOEXCEPT;

/*
* @brief   htclow プロトコルのボディサイズの最大値を返します。
*/
int GetMaxBodySize() NN_NOEXCEPT;

/*
 * @brief   Result の内容を表示します。
 */
void PrintResult(nn::Result result, const char* file, int line) NN_NOEXCEPT;

/*
 * @brief   ランダムな値で初期化された配列を作成します。
 */
std::unique_ptr<uint8_t[]> MakeRandomArray(int size, int seed) NN_NOEXCEPT;

/*
 * @brief   ゼロで値が初期化された配列を作成します。
 */
std::unique_ptr<uint8_t[]> MakeZeroArray(int size) NN_NOEXCEPT;

}}
