﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include <nn/htclow.h>
#include <nn/htclow/detail/htclow_DebugApi.h>
#include <nn/htclow/detail/htclow_InternalApi.h>
#include <nn/htclow/server/htclow_Server.h>

#include <nn/sf/sf_ObjectFactory.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

extern "C" void nnMain()
{
    // Start libnn_htclowServer
    nn::htclow::server::Initialize();

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::htclow::server::RegisterUserHipcServer();
    nn::htclow::server::RegisterDebugHipcServer();

    const size_t ThreadStackSize = 16 * 1024;

    NN_ALIGNAS(nn::os::ThreadStackAlignment) uint8_t userServerthreadStack[ThreadStackSize];
    NN_ALIGNAS(nn::os::ThreadStackAlignment) uint8_t debugServerthreadStack[ThreadStackSize];

    nn::os::ThreadType userServerThread;
    nn::os::ThreadType debugServerThread;

    nn::os::CreateThread(&userServerThread,
        [](void*)
        {
            nn::htclow::server::StartUserHipcServer();
            nn::htclow::server::LoopUserHipcServer();
        }
        , nullptr, userServerthreadStack, ThreadStackSize, nn::os::DefaultThreadPriority);
    nn::os::CreateThread(&debugServerThread,
        [](void*)
        {
            nn::htclow::server::StartDebugHipcServer();
            nn::htclow::server::LoopDebugHipcServer();
        }
        , nullptr, debugServerthreadStack, ThreadStackSize, nn::os::DefaultThreadPriority);

    nn::os::StartThread(&userServerThread);
    nn::os::StartThread(&debugServerThread);
#else
    nn::htclow::detail::InitializeForUserApiWith(nn::htclow::server::GetUserServiceObject());
    nn::htclow::detail::InitializeForDebugApiWith(nn::htclow::server::GetDebugServiceObject());
#endif

    // Start gtest
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    int result = RUN_ALL_TESTS();
    ::nnt::Exit(result);
}
