﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/htclow.h>

namespace nnt { namespace htclow {

void DoHandshake(nn::htclow::Channel* pChannel) NN_NOEXCEPT;

void DoShutdownByHost(nn::htclow::Channel* pChannel, int64_t hostSeqeunceId, int64_t targetSequenceId) NN_NOEXCEPT;
void DoShutdownByTarget(nn::htclow::Channel* pChannel, int64_t hostSeqeunceId, int64_t targetSequenceId) NN_NOEXCEPT;
void DoShutdownSimultaneously(nn::htclow::Channel* pChannel, int64_t hostSeqeunceId, int64_t targetSequenceId) NN_NOEXCEPT;

}}
