﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include "../../../../../Programs/Eris/Sources/Libraries/htclow/util/htclow_FixedSizeMap.h"

/*
 * @file FixedSizeMap クラスのテスト
 */

namespace nnt { namespace htclow {

TEST(FixedSizeMapTest, Basic)
{
    const int maxSize = 16;
    nn::htclow::util::FixedSizeMap<maxSize, int, const char*> m;

    // max_size()
    ASSERT_EQ(maxSize, m.max_size());

    // size == 0 の時のサイズ取得系関数
    ASSERT_EQ(0, m.size());
    ASSERT_TRUE(m.empty());

    // 要素の追加
    m.insert(std::make_pair(1, "1"));
    m.insert(std::make_pair(3, "3"));
    m.insert(std::make_pair(5, "5"));
    m.insert(std::make_pair(2, "2"));
    m.insert(std::make_pair(4, "4"));

    // size != 0 の時のサイズ取得系関数
    ASSERT_EQ(5, m.size());
    ASSERT_FALSE(m.empty());

    // 要素の読み取り
    ASSERT_STREQ(m.at(4), "4");
    ASSERT_STREQ(m.at(2), "2");
    ASSERT_STREQ(m.at(3), "3");
    ASSERT_STREQ(m.at(1), "1");
    ASSERT_STREQ(m.at(5), "5");

    // 削除した後、同じキーに対して別の値を挿入
    m.erase(3);
    ASSERT_EQ(4, m.size());

    m.insert(std::make_pair(3, "three"));
    ASSERT_STREQ(m.at(3), "three");
    ASSERT_EQ(5, m.size());

    // テスト対象より小さいキーを削除
    m.erase(1);
    ASSERT_STREQ(m.at(3), "three");

    m.erase(2);
    ASSERT_STREQ(m.at(3), "three");

    // テスト対象より大きいキーを削除
    m.erase(4);
    ASSERT_STREQ(m.at(3), "three");

    m.erase(5);
    ASSERT_STREQ(m.at(3), "three");
}

}}
