﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * ツールの選択状態を管理するだけの処理
 */

#include "CursolSelect.h"

const int NpadIdNum = 9;

nnt::Cursol t_CursolLeft[NpadIdNum];
nnt::Cursol t_CursolRight[NpadIdNum];

const char* MenuText[] =
{
    "Init/Fin",
    "Hidbus",
    "TrsAPI",
    "Data",
    "Count",
};
const char* InitFinText[] =
{
    "GetHandle",
    "Initialize",
    "Finalize",
};
const char* HidbusText[] =
{
    "Enable",
    "Disable",
};
const char* TransModeText[] =
{
    "E_Polling(6Axis)",
    "E_Polling(No6Axis)",
    "D_Polling",
    "Send&Receive",
    "GetPollingData",
    "StopPollingData",
};
const char* DataText[] =
{
    "UniqueID",
    "Strain&Thermister",
    "FwVersion",
    "S_Cal",
    "U_Cal",
    "U_Cal(Write)",
};

const char* PollingNumText[] =
{
    "Undef",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "10",
};

const int MenuTextNum = NN_ARRAY_SIZE(MenuText);

void nnt::InitializeCursol(Cursol* cursol, size_t index)
{
    cursol->menustate = Menustate_OutForcus;
    cursol->pollingNumSelect = 1;
    cursol->data = Data_UniqueId;
    cursol->IsSelectedWriteUserCal = false;

    t_CursolLeft[index].menustate = Menustate_OutForcus;
    t_CursolLeft[index].pollingNumSelect = 1;
    t_CursolLeft[index].data = Data_UniqueId;
    t_CursolLeft[index].IsSelectedWriteUserCal = false;

    t_CursolRight[index].menustate = Menustate_OutForcus;
    t_CursolRight[index].pollingNumSelect = 1;
    t_CursolRight[index].data = Data_UniqueId;
    t_CursolRight[index].IsSelectedWriteUserCal = false;
}

void nnt::SetUserCal(Cursol* cursol, size_t index)
{
    auto ctrl = gController.GetControllerFromIndex(index);

    if (ctrl->IsTrigger(nn::hid::NpadButton::StickLUp::Mask | nn::hid::NpadButton::StickRUp::Mask | nn::hid::NpadButton::Up::Mask | nn::hid::NpadButton::X::Mask))
    {
        cursol->userCalIndex = cursol->userCalIndex == 0 ? 3 : cursol->userCalIndex - 1;
    }

    if (ctrl->IsTrigger(nn::hid::NpadButton::StickLDown::Mask | nn::hid::NpadButton::StickRDown::Mask | nn::hid::NpadButton::Down::Mask | nn::hid::NpadButton::B::Mask))
    {
        cursol->userCalIndex = cursol->userCalIndex == 3 ? 0 : cursol->userCalIndex + 1;
    }

    if (ctrl->IsTrigger(nn::hid::NpadButton::StickLRight::Mask | nn::hid::NpadButton::Right::Mask | nn::hid::NpadButton::StickRRight::Mask | nn::hid::NpadButton::A::Mask)
    ||  ctrl->IsRepeat(nn::hid::NpadButton::StickLRight::Mask | nn::hid::NpadButton::Right::Mask | nn::hid::NpadButton::StickRRight::Mask | nn::hid::NpadButton::A::Mask))
    {
        switch (cursol->userCalIndex)
        {
            case 0:     // OsMax
                cursol->osMax = cursol->osMax == 32600 ? cursol->osMax : cursol->osMax + 100;
                break;
            case 1:     // HkMax
                cursol->hkMax = cursol->hkMax == 32600 ? cursol->hkMax : cursol->hkMax + 100;
                break;
            case 2:     // ZeroMin
                cursol->zeroMin = cursol->zeroMin == 32600 ? cursol->zeroMin : cursol->zeroMin + 100;
                break;
            case 3:     // ZeroMax
                cursol->zeroMax = cursol->zeroMax == 32600 ? cursol->zeroMax : cursol->zeroMax + 100;
                break;
            default:
                break;
        }
    }

    if (ctrl->IsTrigger(nn::hid::NpadButton::StickLLeft::Mask | nn::hid::NpadButton::Left::Mask | nn::hid::NpadButton::StickRLeft::Mask | nn::hid::NpadButton::Y::Mask)
    ||  ctrl->IsRepeat(nn::hid::NpadButton::StickLLeft::Mask | nn::hid::NpadButton::Left::Mask | nn::hid::NpadButton::StickRLeft::Mask | nn::hid::NpadButton::Y::Mask))
    {
        switch (cursol->userCalIndex)
        {
            case 0:     // OsMax
                cursol->osMax = cursol->osMax == -32600 ? cursol->osMax : cursol->osMax - 100;
                break;
            case 1:     // HkMax
                cursol->hkMax = cursol->hkMax == -32600 ? cursol->hkMax : cursol->hkMax - 100;
                break;
            case 2:     // ZeroMin
                cursol->zeroMin = cursol->zeroMin == -32600 ? cursol->zeroMin : cursol->zeroMin - 100;
                break;
            case 3:     // ZeroMax
                cursol->zeroMax = cursol->zeroMax == -32600 ? cursol->zeroMax : cursol->zeroMax - 100;
                break;
            default:
                break;
        }
    }
    if (ctrl->IsTrigger(nn::hid::NpadButton::L::Mask | nn::hid::NpadButton::R::Mask))
    {
        cursol->IsSelectedWriteUserCal = false;
    }

    nn::util::Float2 pos;
    nn::util::Float2 size;

    pos.x = 1090;
    pos.y = 120;
    size.x = 180;
    size.y = 140;

    nn::util::Color4u8 color;

    gDrawer.SetColor(nn::util::Color4u8::Blue());
    gDrawer.Draw2DRect(pos, size);
    gDrawer.SetColor(nn::util::Color4u8::White());
    gDrawer.Draw2DFrame(pos, size, 1.f);

    color = cursol->userCalIndex == 0 ? nn::util::Color4u8::Magenta() : nn::util::Color4u8::White();
    gTextWriter.SetTextColor(color);
    gTextWriter.SetCursor(pos.x + 10, pos.y + 10);
    gTextWriter.Print("OsMax");
    gTextWriter.SetCursor(pos.x + 100, pos.y + 10);
    gTextWriter.Print("%d",cursol->osMax);

    color = cursol->userCalIndex == 1 ? nn::util::Color4u8::Magenta() : nn::util::Color4u8::White();
    gTextWriter.SetTextColor(color);
    gTextWriter.SetCursor(pos.x + 10, pos.y + 40);
    gTextWriter.Print("HkMax");
    gTextWriter.SetCursor(pos.x + 100, pos.y + 40);
    gTextWriter.Print("%d", cursol->hkMax);

    color = cursol->userCalIndex == 2 ? nn::util::Color4u8::Magenta() : nn::util::Color4u8::White();
    gTextWriter.SetTextColor(color);
    gTextWriter.SetCursor(pos.x + 10, pos.y + 70);
    gTextWriter.Print("ZeroMin");
    gTextWriter.SetCursor(pos.x + 100, pos.y + 70);
    gTextWriter.Print("%d", cursol->zeroMin);

    color = cursol->userCalIndex == 3 ? nn::util::Color4u8::Magenta() : nn::util::Color4u8::White();
    gTextWriter.SetTextColor(color);
    gTextWriter.SetCursor(pos.x + 10, pos.y + 100);
    gTextWriter.Print("ZeroMax");
    gTextWriter.SetCursor(pos.x + 100, pos.y + 100);
    gTextWriter.Print("%d", cursol->zeroMax);
}

void nnt::GetAndDrawCursolPosition(Cursol* cursol, float x, float y, size_t index)
{
    auto ctrl = gController.GetControllerFromIndex(index);

    if (cursol->IsSelectedWriteUserCal == false)
    {
        ////////////////////////////////
        // 選択状況の判定
        ////////////////////////////////
        if (ctrl->IsTrigger(nn::hid::NpadButton::StickLRight::Mask | nn::hid::NpadButton::Right::Mask | nn::hid::NpadButton::StickRRight::Mask | nn::hid::NpadButton::A::Mask))
        {
            switch (cursol->menustate)
            {
                case Menustate_OutForcus:
                    cursol->menustate = Menustate_ForcusLeft;
                    break;
                case Menustate_ForcusLeft:
                    cursol->menustate = Menustate_ForcusRight;
                    break;
                case Menustate_ForcusRight:
                    cursol->menustate = Menustate_OutForcus;
                    break;
                default:
                    break;
            }
        }
        if (ctrl->IsTrigger(nn::hid::NpadButton::StickLLeft::Mask | nn::hid::NpadButton::Left::Mask | nn::hid::NpadButton::StickRLeft::Mask | nn::hid::NpadButton::Y::Mask))
        {
            switch (cursol->menustate)
            {
                case Menustate_OutForcus:
                    // Do nothing
                    break;
                case Menustate_ForcusLeft:
                    cursol->menustate = Menustate_OutForcus;
                    break;
                case Menustate_ForcusRight:
                    cursol->menustate = Menustate_ForcusLeft;
                    break;
                default:
                    break;
            }
        }
        ////////////////////////////////
        // メニュー選択の判定
        ////////////////////////////////
        if (cursol->menustate == Menustate_OutForcus)
        {
            if (ctrl->IsTrigger(nn::hid::NpadButton::StickLUp::Mask | nn::hid::NpadButton::StickRUp::Mask | nn::hid::NpadButton::Up::Mask | nn::hid::NpadButton::X::Mask))
            {
                switch (cursol->menu)
                {
                    case Menu_InitFin:
                        cursol->menu = Menu_PollingNumSelect;
                        break;
                    case Menu_Hidbus:
                        cursol->menu = Menu_InitFin;
                        break;
                    case Menu_TransMode:
                        cursol->menu = Menu_Hidbus;
                        break;
                    case Menu_Data:
                        cursol->menu = Menu_TransMode;
                        break;
                    case Menu_PollingNumSelect:
                        cursol->menu = Menu_Data;
                        break;
                    default:
                        break;
                }
            }
            if (ctrl->IsTrigger(nn::hid::NpadButton::StickLDown::Mask | nn::hid::NpadButton::StickRDown::Mask | nn::hid::NpadButton::Down::Mask | nn::hid::NpadButton::B::Mask))
            {
                switch (cursol->menu)
                {
                    case Menu_InitFin:
                        cursol->menu = Menu_Hidbus;
                        break;
                    case Menu_Hidbus:
                        cursol->menu = Menu_TransMode;
                        break;
                    case Menu_TransMode:
                        cursol->menu = Menu_Data;
                        break;
                    case Menu_Data:
                        cursol->menu = Menu_PollingNumSelect;
                        break;
                    case Menu_PollingNumSelect:
                        cursol->menu = Menu_InitFin;
                        break;
                    default:
                        break;
                }
            }
        }
        ////////////////////////////////////////////
        // メニュー選択後の各内容の判定
        ////////////////////////////////////////////
        if (cursol->menustate == Menustate_ForcusLeft || cursol->menustate == Menustate_ForcusRight)
        {
            if (ctrl->IsTrigger(nn::hid::NpadButton::StickLUp::Mask | nn::hid::NpadButton::StickRUp::Mask | nn::hid::NpadButton::Up::Mask | nn::hid::NpadButton::X::Mask))
            {
                switch (cursol->menu)
                {
                    case Menu_InitFin:
                        switch (cursol->initfin)
                        {
                            case InitFin_GetHandle:
                                cursol->initfin = InitFin_Fin;
                                break;
                            case InitFin_Init:
                                cursol->initfin = InitFin_GetHandle;
                                break;
                            case InitFin_Fin:
                                cursol->initfin = InitFin_Init;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_Hidbus:
                        cursol->hidbus = (cursol->hidbus == Hidbus_Enable) ? Hidbus_Disable : Hidbus_Enable;
                        break;
                    case Menu_TransMode:
                        switch (cursol->trsmode)
                        {
                            case TransMode_EnablePolling6Axis:
                                cursol->trsmode = TransMode_StopGetPollingData;
                                break;
                            case TransMode_EnablePollingNo6Axis:
                                cursol->trsmode = TransMode_EnablePolling6Axis;
                                break;
                            case TransMode_DisablePolling:
                                cursol->trsmode = TransMode_EnablePollingNo6Axis;
                                break;
                            case TransMode_SendAndReceive:
                                cursol->trsmode = TransMode_DisablePolling;
                                break;
                            case TransMode_GetPollingData:
                                cursol->trsmode = TransMode_SendAndReceive;
                                break;
                            case TransMode_StopGetPollingData:
                                cursol->trsmode = TransMode_GetPollingData;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_Data:
                        switch (cursol->data)
                        {
                            case Data_UniqueId:
                                cursol->data = Data_WriteUCal;
                                break;
                            case Data_PollingFormat:
                                cursol->data = Data_UniqueId;
                                break;
                            case Data_FwVersion:
                                cursol->data = Data_PollingFormat;
                                break;
                            case Data_SCal:
                                cursol->data = Data_FwVersion;
                                break;
                            case Data_UCal:
                                cursol->data = Data_SCal;
                                break;
                            case Data_WriteUCal:
                                cursol->data = Data_UCal;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_PollingNumSelect:
                        if (cursol->pollingNumSelect == 1)
                        {
                            cursol->pollingNumSelect = 10;
                        }
                        else
                        {
                            cursol->pollingNumSelect--;
                        }
                        break;
                    default:
                        break;
                }
            }
            if (ctrl->IsTrigger(nn::hid::NpadButton::StickLDown::Mask | nn::hid::NpadButton::StickRDown::Mask | nn::hid::NpadButton::Down::Mask | nn::hid::NpadButton::B::Mask))
            {
                switch (cursol->menu)
                {
                    case Menu_InitFin:
                        switch (cursol->initfin)
                        {
                            case InitFin_GetHandle:
                                cursol->initfin = InitFin_Init;
                                break;
                            case InitFin_Init:
                                cursol->initfin = InitFin_Fin;
                                break;
                            case InitFin_Fin:
                                cursol->initfin = InitFin_GetHandle;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_Hidbus:
                        cursol->hidbus = (cursol->hidbus == Hidbus_Enable) ? Hidbus_Disable : Hidbus_Enable;
                        break;
                    case Menu_TransMode:
                        switch (cursol->trsmode)
                        {
                            case TransMode_EnablePolling6Axis:
                                cursol->trsmode = TransMode_EnablePollingNo6Axis;
                                break;
                            case TransMode_EnablePollingNo6Axis:
                                cursol->trsmode = TransMode_DisablePolling;
                                break;
                            case TransMode_DisablePolling:
                                cursol->trsmode = TransMode_SendAndReceive;
                                break;
                            case TransMode_SendAndReceive:
                                cursol->trsmode = TransMode_GetPollingData;
                                break;
                            case TransMode_GetPollingData:
                                cursol->trsmode = TransMode_StopGetPollingData;
                                break;
                            case TransMode_StopGetPollingData:
                                cursol->trsmode = TransMode_EnablePolling6Axis;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_Data:
                        switch (cursol->data)
                        {
                            case Data_UniqueId:
                                cursol->data = Data_PollingFormat;
                                break;
                            case Data_PollingFormat:
                                cursol->data = Data_FwVersion;
                                break;
                            case Data_FwVersion:
                                cursol->data = Data_SCal;
                                break;
                            case Data_SCal:
                                cursol->data = Data_UCal;
                                break;
                            case Data_UCal:
                                cursol->data = Data_WriteUCal;
                                break;
                            case Data_WriteUCal:
                                cursol->data = Data_UniqueId;
                                break;
                            default:
                                break;
                        }
                        break;
                    case Menu_PollingNumSelect:
                        if (cursol->pollingNumSelect == 10)
                        {
                            cursol->pollingNumSelect = 1;
                        }
                        else
                        {
                            cursol->pollingNumSelect++;
                        }
                        break;
                    default:
                        break;
                }
            }
            //////////////////////////////////////////////////////
            // 中項目が選択された場合、選択したことを1回のみ返す
            //////////////////////////////////////////////////////
            if (ctrl->IsTrigger(nn::hid::NpadButton::L::Mask | nn::hid::NpadButton::R::Mask))
            {
                if (cursol->menustate == Menustate_ForcusLeft)
                {
                    cursol->IsSelectedLeft = true;
                }
                else
                {
                    cursol->IsSelectedRight = true;
                }
                // ユーザーCalを書き込む場合、書き込みデータを指定したいのでフラグを立てる
                if (cursol->menu == Menu_Data && cursol->data == Data_WriteUCal)
                {
                    cursol->IsSelectedWriteUserCal = true;
                }
            }
            else
            {
                if (cursol->menustate == Menustate_ForcusLeft)
                {
                    cursol->IsSelectedLeft = false;
                }
                else
                {
                    cursol->IsSelectedRight = false;
                }
            }
        }
    }
    else
    {
        SetUserCal(cursol, index);
    }


    ///////////////////////////////////////
    // 描画処理
    ///////////////////////////////////////
    if (cursol->menustate == Menustate_ForcusLeft)
    {
        t_CursolLeft[index] = *cursol;
    }
    if (cursol->menustate == Menustate_ForcusRight)
    {
        t_CursolRight[index] = *cursol;
    }

    gTextWriter.SetScale(1.0f, 1.0f);

    nn::util::Float2 pos;
    nn::util::Float2 size;

    nn::util::Float2 LeftLineBegin;
    nn::util::Float2 LeftLineEnd;
    nn::util::Float2 RightLineBegin;
    nn::util::Float2 RightLineEnd;

    nn::util::Color4u8 selectColor;

    if (cursol->IsSelectedLeft == true || cursol->IsSelectedRight == true)
    {
        selectColor = nn::util::Color4u8::White();
    }
    else
    {
        selectColor = nn::util::Color4u8::Red();
    }

    for(auto i = 0; i < MenuTextNum; i++)
    {
        if(i == cursol->menu)
        {
            gTextWriter.SetCursor(x - 20, y + 30 * i);
            gTextWriter.SetTextColor(nn::util::Color4u8::Red());
            gTextWriter.Print("⇒");

            gTextWriter.SetTextColor(cursol->menustate == Menustate_OutForcus ? nn::util::Color4u8::Red() : nn::util::Color4u8::Black());
            gTextWriter.SetCursor(x + 5, y + 30 * i);
            gTextWriter.Print("%s", MenuText[i]);
        }
        else
        {
            gTextWriter.SetTextColor(nn::util::Color4u8::Black());

            gTextWriter.SetCursor(x + 5, y + 30 * i);
            gTextWriter.Print("%s", MenuText[i]);
        }

        pos.x = x;
        pos.y = y + 30 * i;
        size.x = 400.0f;
        size.y = 28.0f;

        LeftLineBegin.x = pos.x + 80;
        LeftLineEnd.x = LeftLineBegin.x;
        LeftLineBegin.y = pos.y;
        LeftLineEnd.y = pos.y + size.y;

        RightLineBegin.x = LeftLineBegin.x + 160;
        RightLineEnd.x = RightLineBegin.x;
        RightLineBegin.y = pos.y;
        RightLineEnd.y = pos.y + size.y;

        nn::util::Color4u8 color;

        gDrawer.SetColor(nn::util::Color4u8::Gray());
        gDrawer.Draw2DFrame(pos, size, 2.f);
        gDrawer.Draw2DLine(LeftLineBegin, LeftLineEnd);
        gDrawer.Draw2DLine(RightLineBegin, RightLineEnd);
    }
    gTextWriter.SetTextColor(nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y - 25);
    gTextWriter.Print("[Left]");

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusLeft && cursol->menu == Menu_InitFin
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y + 0);
    gTextWriter.Print("%s", InitFinText[t_CursolLeft[index].initfin]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusLeft && cursol->menu == Menu_Hidbus
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y + 30);
    gTextWriter.Print("%s", HidbusText[t_CursolLeft[index].hidbus]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusLeft && cursol->menu == Menu_TransMode
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y + 60);
    gTextWriter.Print("%s", TransModeText[t_CursolLeft[index].trsmode]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusLeft && cursol->menu == Menu_Data
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y + 90);
    gTextWriter.Print("%s", DataText[t_CursolLeft[index].data]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusLeft && cursol->menu == Menu_PollingNumSelect
                             ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(LeftLineBegin.x + 5, y + 120);
    gTextWriter.Print("%s", PollingNumText[t_CursolLeft[index].pollingNumSelect]);

    gTextWriter.SetTextColor(nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y - 25);
    gTextWriter.Print("[Right]");

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusRight && cursol->menu == Menu_InitFin
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y + 0);
    gTextWriter.Print("%s", InitFinText[t_CursolRight[index].initfin]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusRight && cursol->menu == Menu_Hidbus
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y + 30);
    gTextWriter.Print("%s", HidbusText[t_CursolRight[index].hidbus]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusRight && cursol->menu == Menu_TransMode
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y + 60);
    gTextWriter.Print("%s", TransModeText[t_CursolRight[index].trsmode]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusRight && cursol->menu == Menu_Data
                                ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y + 90);
    gTextWriter.Print("%s", DataText[t_CursolRight[index].data]);

    gTextWriter.SetTextColor(cursol->menustate == Menustate_ForcusRight && cursol->menu == Menu_PollingNumSelect
                             ? selectColor : nn::util::Color4u8::Black());
    gTextWriter.SetCursor(RightLineBegin.x + 5, y + 120);
    gTextWriter.Print("%s", PollingNumText[t_CursolRight[index].pollingNumSelect]);
} // NOLINT(impl/function_size)
