﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>

#include <nn/fs.h>
#include <nn/fs/fs_Debug.h>
#include <nn/os/os_TickTypes.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

class SixAxisSensorLogger
{
    NN_DISALLOW_COPY(SixAxisSensorLogger);
    NN_DISALLOW_MOVE(SixAxisSensorLogger);

public:
    static const int   FileNameCountMax = 256;

private:
    nn::fs::FileHandle m_FileHandle;
    int64_t            m_FileOffset;
    char               m_FileName[FileNameCountMax];

    bool               m_IsSdCardInserted;

    nn::os::Tick       m_StartTick;

public:
    SixAxisSensorLogger() NN_NOEXCEPT;

    void Initialize(const char* pFileName) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    void ResetTick() NN_NOEXCEPT;

    void AppendLine(void* pState) NN_NOEXCEPT;
};
