﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"

class ShakeMotionDetector final : public IMotionDetector
{
    NN_DISALLOW_COPY(ShakeMotionDetector);
    NN_DISALLOW_MOVE(ShakeMotionDetector);

public:

    ShakeMotionDetector() NN_NOEXCEPT;

    virtual ~ShakeMotionDetector() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT NN_OVERRIDE;

private:
    SixAxisSensorRawState m_RawState;
    int m_ShakeCount; //!< Shake 回数
    int m_ThresholdShakeCount; //!< Shake 検出閾値

    int64_t m_ThresholdShakeResetSampleCount;      // 前回の Shake から 100 * 5ms 経過したらリセットする
    float   m_ThresholdAccelerometerLengthSquared; // Shake 判定の加速度閾値 [G^2]
    float   m_ThresholdCos;                        // Shake 判定の加速度がなす角の cos [-1.f, 1.f]
};
