﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"

const int SixAxisSensorRotationStateCountMax = 16; //!< 内部的に保持できる回転のサンプル数

//!< 回転入力状態を表す構造体です。
struct SixAxisSensorRotationState
{
    int64_t samplingNumber;
    ::nn::util::Vector3f rotation;

    void Reset() NN_NOEXCEPT
    {
        ::nn::util::VectorZero(&rotation);
    }
};

// 回転入力状態の LIFO です。
class SixAxisSensorRotationStateLifo final :
    public ::nn::hid::detail::RingLifo<SixAxisSensorRotationState, SixAxisSensorRotationStateCountMax>
{
public:
    SixAxisSensorRotationStateLifo() NN_NOEXCEPT { /* 何もしない */ }
};

#ifdef NN_BUILD_CONFIG_TOOLCHAIN_CLANG
NN_STATIC_ASSERT(::std::is_standard_layout<SixAxisSensorRotationStateLifo>::value);
#endif

class RotateMotionDetector final : public IMotionDetector
{
    NN_DISALLOW_COPY(RotateMotionDetector);
    NN_DISALLOW_MOVE(RotateMotionDetector);

public:

    RotateMotionDetector() NN_NOEXCEPT;

    virtual ~RotateMotionDetector() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT NN_OVERRIDE;

private:

    SixAxisSensorRotationState m_RotationState;
    SixAxisSensorRotationStateLifo m_RotationStateLifo;

    int64_t m_RotationStateSamplingNumber;
    float m_SamplingIntervalSeconds; // サンプリング周期 [sec]

    float m_ThresholdRotationStartedLengthSquared; // 角速度二乗和の検出閾値
    bool m_IsRotationStarted; // 検出中か
    SixAxisSensorRotationState m_RotationStartedState; // 回転開始時の入力状態
};
